/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;

public class HttpSessionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6380136823410869457L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("httpsessions.table.header.active"), Constant.messages.getString("httpsessions.table.header.name"), Constant.messages.getString("httpsessions.table.header.tokens"), Constant.messages.getString("httpsessions.table.header.matched")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private ArrayList<HttpSession> sessions;
    private HttpSessionsSite site;
    private static final ImageIcon activeIcon = new ImageIcon(HttpSessionsTableModel.class.getResource("/resource/icon/16/102.png"));

    public HttpSessionsTableModel(HttpSessionsSite httpSessionsSite) {
        this.site = httpSessionsSite;
        this.sessions = new ArrayList(2);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.sessions.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.sessions.size()) {
            return null;
        }
        HttpSession httpSession = this.sessions.get(n);
        switch (n2) {
            case 0: {
                if (httpSession.isActive()) {
                    return activeIcon;
                }
                return null;
            }
            case 1: {
                return httpSession.getName();
            }
            case 2: {
                return httpSession.getTokenValuesString();
            }
            case 3: {
                return httpSession.getMessagesMatched();
            }
        }
        return null;
    }

    public void removeAllElements() {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.removeAllElements();
                }
            });
            return;
        }
        this.sessions.clear();
        this.sessions.trimToSize();
        this.fireTableDataChanged();
    }

    public void addHttpSession(final HttpSession httpSession) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.addHttpSession(httpSession);
                }
            });
            return;
        }
        if (this.sessions.contains(httpSession)) {
            return;
        }
        this.sessions.add(httpSession);
        int n = this.sessions.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            this.site.renameHttpSession(this.sessions.get(n).getName(), (String)object);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return null;
    }

    protected HttpSession getHttpSessionAt(int n) {
        if (n < 0 || n >= this.sessions.size()) {
            return null;
        }
        return this.sessions.get(n);
    }

    public void removeHttpSession(final HttpSession httpSession) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.removeHttpSession(httpSession);
                }
            });
            return;
        }
        int n = this.sessions.indexOf(httpSession);
        this.sessions.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void fireHttpSessionUpdated(final HttpSession httpSession) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.fireHttpSessionUpdated(httpSession);
                }
            });
            return;
        }
        int n = this.sessions.indexOf(httpSession);
        this.fireTableRowsUpdated(n, n);
    }
}

