/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.io.IOException;
import java.net.UnknownHostException;
import org.zaproxy.zap.extension.stats.StatsdClient;
import org.zaproxy.zap.utils.StatsListener;

public class Statsd
implements StatsListener {
    private static final String GLOBAL_KEY = "global";
    private StatsdClient statsd2;
    private String host;
    private int port;
    private String prefix;
    private String separator = ".";

    public Statsd(String string, int n, String string2) throws UnknownHostException, IOException {
        this.host = string;
        this.port = n;
        this.prefix = string2;
        this.statsd2 = new StatsdClient(string, n);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    private String getFullKey(String string) {
        return this.getFullKey(null, string);
    }

    private String getFullKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix != null) {
            stringBuilder.append(this.prefix);
            stringBuilder.append(this.separator);
        }
        if (string != null) {
            stringBuilder.append(string.substring(string.indexOf(58) + 3));
        } else {
            stringBuilder.append(GLOBAL_KEY);
        }
        stringBuilder.append(this.separator);
        stringBuilder.append(string2);
        return stringBuilder.toString().replace(":", "-");
    }

    @Override
    public void counterInc(String string) {
        this.statsd2.increment(this.getFullKey(string));
    }

    @Override
    public void counterInc(String string, String string2) {
        this.statsd2.increment(this.getFullKey(string, string2));
    }

    @Override
    public void counterInc(String string, long l) {
        this.statsd2.increment(this.getFullKey(string), (int)l);
    }

    @Override
    public void counterInc(String string, String string2, long l) {
        this.statsd2.increment(this.getFullKey(string, string2), (int)l);
    }

    @Override
    public void counterDec(String string) {
        this.statsd2.decrement(this.getFullKey(string));
    }

    @Override
    public void counterDec(String string, String string2) {
        this.statsd2.decrement(this.getFullKey(string, string2));
    }

    @Override
    public void counterDec(String string, long l) {
        this.statsd2.decrement(this.getFullKey(string), (int)l);
    }

    @Override
    public void counterDec(String string, String string2, long l) {
        this.statsd2.decrement(this.getFullKey(string, string2), (int)l);
    }

    @Override
    public void highwaterMarkSet(String string, long l) {
        this.statsd2.gauge(this.getFullKey(string), l);
    }

    @Override
    public void highwaterMarkSet(String string, String string2, long l) {
        this.statsd2.gauge(this.getFullKey(string, string2), l);
    }

    @Override
    public void lowwaterMarkSet(String string, long l) {
        this.statsd2.gauge(this.getFullKey(string), l);
    }

    @Override
    public void lowwaterMarkSet(String string, String string2, long l) {
        this.statsd2.gauge(this.getFullKey(string, string2), l);
    }

    @Override
    public void allCleared() {
    }

    @Override
    public void allCleared(String string) {
    }

    @Override
    public void cleared(String string) {
    }

    @Override
    public void cleared(String string, String string2) {
    }
}

