/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.utils.ApiUtils;

public class CookieBasedSessionManagementMethodType
extends SessionManagementMethodType {
    private static final int METHOD_IDENTIFIER = 0;
    private static final Logger log = Logger.getLogger(CookieBasedSessionManagementMethod.class);
    private static final String METHOD_NAME = Constant.messages.getString("sessionmanagement.method.cb.name");
    private static final String API_METHOD_NAME = "cookieBasedSessionManagement";

    @Override
    public CookieBasedSessionManagementMethod createSessionManagementMethod(int n) {
        return new CookieBasedSessionManagementMethod(n);
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public AbstractSessionManagementMethodOptionsPanel buildOptionsPanel(Context context) {
        return null;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean isTypeForMethod(SessionManagementMethod sessionManagementMethod) {
        return sessionManagementMethod instanceof CookieBasedSessionManagementMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public int getUniqueIdentifier() {
        return 0;
    }

    @Override
    public SessionManagementMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        return new CookieBasedSessionManagementMethod(n);
    }

    @Override
    public void persistMethodToSession(Session session, int n, SessionManagementMethod sessionManagementMethod) throws SessionManagementMethodType.UnsupportedSessionManagementMethodException, DatabaseException {
    }

    @Override
    public void exportData(Configuration configuration, SessionManagementMethod sessionManagementMethod) {
    }

    @Override
    public void importData(Configuration configuration, SessionManagementMethod sessionManagementMethod) throws ConfigurationException {
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                context.setSessionManagementMethod(CookieBasedSessionManagementMethodType.this.createSessionManagementMethod(context.getIndex()));
            }
        };
    }

    public static class CookieBasedSession
    extends WebSession {
        private static int generatedNameIndex;

        public CookieBasedSession(String string) {
            super(string, new HttpState());
        }

        public CookieBasedSession() {
            super("Cookie Based Session " + generatedNameIndex++, new HttpState());
        }
    }

    public static class CookieBasedSessionManagementMethod
    implements SessionManagementMethod {
        private int contextId;
        private Context context;
        private static WeakReference<ExtensionHttpSessions> extHttpSessions;

        public CookieBasedSessionManagementMethod(int n) {
            this.contextId = n;
        }

        public String toString() {
            return METHOD_NAME;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        private Cookie convertCookie(HttpCookie httpCookie) {
            Cookie cookie = new Cookie(httpCookie.getDomain(), httpCookie.getName(), httpCookie.getValue(), httpCookie.getPath(), (int)httpCookie.getMaxAge(), httpCookie.getSecure());
            cookie.setVersion(httpCookie.getVersion());
            cookie.setComment(httpCookie.getComment());
            return cookie;
        }

        @Override
        public WebSession extractWebSession(HttpMessage httpMessage) {
            if (httpMessage.getRequestingUser() != null) {
                return httpMessage.getRequestingUser().getAuthenticatedSession();
            }
            CookieBasedSession cookieBasedSession = new CookieBasedSession();
            for (HttpCookie httpCookie : httpMessage.getRequestHeader().getHttpCookies()) {
                cookieBasedSession.getHttpState().addCookie(this.convertCookie(httpCookie));
            }
            for (HttpCookie httpCookie : httpMessage.getResponseHeader().getHttpCookies(httpMessage.getRequestHeader().getHostName())) {
                cookieBasedSession.getHttpState().addCookie(this.convertCookie(httpCookie));
            }
            return cookieBasedSession;
        }

        @Override
        public void processMessageToMatchSession(HttpMessage httpMessage, WebSession webSession) throws SessionManagementMethod.UnsupportedWebSessionException {
            if (webSession.getHttpState() == null) {
                return;
            }
            webSession.getHttpState().purgeExpiredCookies();
            List<HttpCookie> list = httpMessage.getRequestHeader().getHttpCookies();
            Iterator<HttpCookie> iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                HttpCookie httpCookie = iterator.next();
                for (Cookie cookie : webSession.getHttpState().getCookies()) {
                    if (!cookie.getName().equals(httpCookie.getName())) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            httpMessage.setCookies(list);
        }

        private ExtensionHttpSessions getHttpSessionsExtension() {
            if ((extHttpSessions == null || extHttpSessions.get() == null) && (extHttpSessions = new WeakReference<ExtensionHttpSessions>(Control.getSingleton().getExtensionLoader().getExtension(ExtensionHttpSessions.class))) == null) {
                log.error((Object)"An error occured while loading the ExtensionHttpSessions.");
            }
            return (ExtensionHttpSessions)extHttpSessions.get();
        }

        private Context getContext() {
            if (this.context == null) {
                this.context = Model.getSingleton().getSession().getContext(this.contextId);
            }
            return this.context;
        }

        @Override
        public SessionManagementMethod clone() {
            return new CookieBasedSessionManagementMethod(this.contextId);
        }

        @Override
        public void clearWebSessionIdentifiers(HttpMessage httpMessage) {
            HttpSessionTokensSet httpSessionTokensSet = this.getHttpSessionsExtension().getHttpSessionTokensSetForContext(this.getContext());
            if (httpSessionTokensSet == null) {
                log.info((Object)"No tokens to clear.");
                return;
            }
            List<HttpCookie> list = httpMessage.getRequestHeader().getHttpCookies();
            Iterator<HttpCookie> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!httpSessionTokensSet.isSessionToken(iterator.next().getName())) continue;
                iterator.remove();
            }
            httpMessage.setCookies(list);
        }

        @Override
        public SessionManagementMethodType getType() {
            return new CookieBasedSessionManagementMethodType();
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            return new ApiResponseElement("methodName", CookieBasedSessionManagementMethodType.API_METHOD_NAME);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.contextId;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CookieBasedSessionManagementMethod cookieBasedSessionManagementMethod = (CookieBasedSessionManagementMethod)object;
            return this.contextId == cookieBasedSessionManagementMethod.contextId;
        }

        @Override
        public WebSession createEmptyWebSession() {
            return new CookieBasedSession();
        }
    }
}

