# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB::Server
    module Share
      module Command
        module Trans2
          module QueryPathInformation

            # Handles an TRANS2_QUERY_PATH_INFORMATION subcommand, used to get information about
            # an specific file or directory, using its path.
            #
            # @param c [Socket] The client sending the request.
            # @param buff [String] The data including the client request.
            # @return [Fixnum] The number of bytes returned to the client as response.
            def smb_cmd_trans2_query_path_information(c, buff)
              smb = @state[c]

              params = CONST::SMB_TRANS2_QUERY_PATH_PARAMETERS.make_struct
              params.from_s(buff)

              loi = params.v['InformationLevel']
              file_name = normalize_path(params.v['FileName'])

              case loi
              when CONST::SMB_QUERY_FILE_STANDARD_INFO, CONST::SMB_QUERY_FILE_STANDARD_INFO_ALIAS, CONST::SMB_QUERY_FILE_INTERNAL_INFO_ALIAS
                return smb_cmd_trans_query_path_info_standard(c, file_name)
              when CONST::SMB_QUERY_FILE_BASIC_INFO, CONST::SMB_QUERY_FILE_BASIC_INFO_ALIAS, CONST::SMB_SET_FILE_BASIC_INFO_ALIAS
                return smb_cmd_trans_query_path_info_basic(c, file_name)
              when CONST::SMB_QUERY_FILE_NETWORK_OPEN_INFO
                return smb_cmd_trans_query_path_info_network(c, file_name)
              else
                # Send STATUS_SUCCESS with the hope of going ahead
                vprint_status("SMB Share - #{smb[:ip]} Unknown TRANS2_QUERY_PATH_INFORMATION with loi: #{loi.to_s(16)}")
                return smb_error(CONST::SMB_COM_TRANSACTION2, c, CONST::SMB_STATUS_SUCCESS)
              end
            end
          end
        end
      end
    end
  end
end
