
# LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import dbus
from player import PlayerEvents

class GmusicbrowserPlayer(PlayerEvents):
	__name__ = "gmusicbrowser"
	
	def __init__(self, session_bus):
		PlayerEvents.__init__(self, songChange = False, elapsedChange = True, stateChange = True)
		self.session_bus = session_bus
	
	def is_active(self, dbus_iface):
		return "org.gmusicbrowser" in dbus_iface.ListNames()
		
	def connect(self):
		proxy = self.session_bus.get_object("org.gmusicbrowser", "/org/gmusicbrowser")
		self.playerAPI = dbus.Interface(proxy, "org.gmusicbrowser")
		self.playerAPI.connect_to_signal("SongChanged", self.onSongChangedSignal)
		PlayerEvents.connect(self)
	
	def disconnect(self):
		PlayerEvents.disconnect(self)

	def onSongChangedSignal(self, song):
		#print "SONG CHANGE %s" % song
		if self.onSongChanged:
			self.onSongChanged(self.getCurrentFile())
		
	def get_title(self):
		return self.playerAPI.CurrentSong()['title']

	def get_artist(self):
		return self.playerAPI.CurrentSong()['artist']

	def get_album(self):
		return self.playerAPI.CurrentSong()['album']
				
	def getElapsed(self):
		return self.playerAPI.GetPosition()
	
	def getCurrentFile(self):
		print "FILE"
		#print self.playerAPI.CurrentSong()
		#print self.playerAPI.GetLibrary()
		#print self.playerAPI.Get(["0"], 'length')
		return "http"
		 
	def is_playing(self):
		return self.playerAPI.Playing() == 1
