/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.GradientPaintContext;
import java.awt.LinearGradientPaintContext;
import java.awt.MultipleGradientPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.beans.ConstructorProperties;

public final class LinearGradientPaint
extends MultipleGradientPaint {
    private final Point2D start;
    private final Point2D end;

    public LinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        this(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public LinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
        this(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray, cycleMethod);
    }

    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
        this(point2D, point2D2, fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
        this(point2D, point2D2, fArray, colorArray, cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform());
    }

    @ConstructorProperties(value={"startPoint", "endPoint", "fractions", "colors", "cycleMethod", "colorSpace", "transform"})
    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpaceType, AffineTransform affineTransform) {
        super(fArray, colorArray, cycleMethod, colorSpaceType, affineTransform);
        if (point2D == null || point2D2 == null) {
            throw new NullPointerException("Start and end points must benon-null");
        }
        if (point2D.equals(point2D2)) {
            throw new IllegalArgumentException("Start point cannot equalendpoint");
        }
        this.start = new Point2D.Double(point2D.getX(), point2D.getY());
        this.end = new Point2D.Double(point2D2.getX(), point2D2.getY());
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.concatenate(this.gradientTransform);
        if (this.fractions.length == 2 && this.cycleMethod != MultipleGradientPaint.CycleMethod.REPEAT && this.colorSpace == MultipleGradientPaint.ColorSpaceType.SRGB) {
            boolean bl = this.cycleMethod != MultipleGradientPaint.CycleMethod.NO_CYCLE;
            return new GradientPaintContext(colorModel, this.start, this.end, affineTransform, this.colors[0], this.colors[1], bl);
        }
        return new LinearGradientPaintContext(this, colorModel, rectangle, rectangle2D, affineTransform, renderingHints, this.start, this.end, this.fractions, this.colors, this.cycleMethod, this.colorSpace);
    }

    public Point2D getStartPoint() {
        return new Point2D.Double(this.start.getX(), this.start.getY());
    }

    public Point2D getEndPoint() {
        return new Point2D.Double(this.end.getX(), this.end.getY());
    }
}

