/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Rfc2253Parser;

public class Rdn
implements Serializable,
Comparable<Object> {
    private transient ArrayList entries;
    private static final int DEFAULT_SIZE = 1;
    private static final long serialVersionUID = -5994465067210009656L;
    private static final String escapees = ",=+<>#;\"\\";

    public Rdn(Attributes attrSet) throws InvalidNameException {
        if (attrSet.size() == 0) {
            throw new InvalidNameException("Attributes cannot be empty");
        }
        this.entries = new ArrayList(attrSet.size());
        NamingEnumeration<? extends Attribute> attrs = attrSet.getAll();
        try {
            int nEntries = 0;
            while (attrs.hasMore()) {
                RdnEntry entry = new RdnEntry();
                Attribute attr = attrs.next();
                entry.type = attr.getID();
                entry.value = attr.get();
                this.entries.add(nEntries, entry);
                ++nEntries;
            }
        }
        catch (NamingException e) {
            InvalidNameException e2 = new InvalidNameException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        this.sort();
    }

    public Rdn(String rdnString) throws InvalidNameException {
        this.entries = new ArrayList(1);
        new Rfc2253Parser(rdnString).parseRdn(this);
    }

    public Rdn(Rdn rdn) {
        this.entries = new ArrayList(rdn.entries.size());
        this.entries.addAll(rdn.entries);
    }

    public Rdn(String type, Object value) throws InvalidNameException {
        if (value == null) {
            throw new NullPointerException("Cannot set value to null");
        }
        if (type.equals("") || this.isEmptyValue(value)) {
            throw new InvalidNameException("type or value cannot be empty, type:" + type + " value:" + value);
        }
        this.entries = new ArrayList(1);
        this.put(type, value);
    }

    private boolean isEmptyValue(Object val) {
        return val instanceof String && val.equals("") || val instanceof byte[] && ((byte[])val).length == 0;
    }

    Rdn() {
        this.entries = new ArrayList(1);
    }

    Rdn put(String type, Object value) {
        RdnEntry newEntry = new RdnEntry();
        newEntry.type = type;
        if (value instanceof byte[]) {
            newEntry.value = ((byte[])value).clone();
        } else {
            newEntry.value = value;
        }
        this.entries.add(newEntry);
        return this;
    }

    void sort() {
        if (this.entries.size() > 1) {
            Collections.sort(this.entries);
        }
    }

    public Object getValue() {
        return ((RdnEntry)this.entries.get(0)).getValue();
    }

    public String getType() {
        return ((RdnEntry)this.entries.get(0)).getType();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.entries.size();
        if (size > 0) {
            builder.append(this.entries.get(0));
        }
        for (int next = 1; next < size; ++next) {
            builder.append('+');
            builder.append(this.entries.get(next));
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof Rdn)) {
            throw new ClassCastException("The obj is not a Rdn");
        }
        if (obj == this) {
            return 0;
        }
        Rdn that = (Rdn)obj;
        int minSize = Math.min(this.entries.size(), that.entries.size());
        for (int i = 0; i < minSize; ++i) {
            int diff = ((RdnEntry)this.entries.get(i)).compareTo(that.entries.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return this.entries.size() - that.entries.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Rdn)) {
            return false;
        }
        Rdn that = (Rdn)obj;
        if (this.entries.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).equals(that.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            hash += this.entries.get(i).hashCode();
        }
        return hash;
    }

    public Attributes toAttributes() {
        BasicAttributes attrs = new BasicAttributes(true);
        for (int i = 0; i < this.entries.size(); ++i) {
            RdnEntry entry = (RdnEntry)this.entries.get(i);
            Attribute attr = attrs.put(entry.getType(), entry.getValue());
            if (attr == null) continue;
            attr.add(entry.getValue());
            attrs.put(attr);
        }
        return attrs;
    }

    public int size() {
        return this.entries.size();
    }

    public static String escapeValue(Object val) {
        return val instanceof byte[] ? Rdn.escapeBinaryValue((byte[])val) : Rdn.escapeStringValue((String)val);
    }

    private static String escapeStringValue(String val) {
        int trail;
        int lead;
        char[] chars = val.toCharArray();
        StringBuilder builder = new StringBuilder(2 * val.length());
        for (lead = 0; lead < chars.length && Rdn.isWhitespace(chars[lead]); ++lead) {
        }
        for (trail = chars.length - 1; trail >= 0 && Rdn.isWhitespace(chars[trail]); --trail) {
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i < lead || i > trail || escapees.indexOf(c) >= 0) {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static String escapeBinaryValue(byte[] val) {
        StringBuilder builder = new StringBuilder(1 + 2 * val.length);
        builder.append("#");
        for (int i = 0; i < val.length; ++i) {
            byte b = val[i];
            builder.append(Character.forDigit(0xF & b >>> 4, 16));
            builder.append(Character.forDigit(0xF & b, 16));
        }
        return builder.toString();
    }

    public static Object unescapeValue(String val) {
        int beg;
        char[] chars = val.toCharArray();
        int end = chars.length;
        for (beg = 0; beg < end && Rdn.isWhitespace(chars[beg]); ++beg) {
        }
        while (beg < end && Rdn.isWhitespace(chars[end - 1])) {
            --end;
        }
        if (end != chars.length && beg < end && chars[end - 1] == '\\') {
            ++end;
        }
        if (beg >= end) {
            return "";
        }
        if (chars[beg] == '#') {
            return Rdn.decodeHexPairs(chars, ++beg, end);
        }
        if (chars[beg] == '\"' && chars[end - 1] == '\"') {
            ++beg;
            --end;
        }
        StringBuilder builder = new StringBuilder(end - beg);
        int esc = -1;
        for (int i = beg; i < end; ++i) {
            if (chars[i] == '\\' && i + 1 < end) {
                if (!Character.isLetterOrDigit(chars[i + 1])) {
                    builder.append(chars[++i]);
                    esc = i;
                    continue;
                }
                byte[] utf8 = Rdn.getUtf8Octets(chars, i, end);
                if (utf8.length > 0) {
                    try {
                        builder.append(new String(utf8, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    i += utf8.length * 3 - 1;
                    continue;
                }
                throw new IllegalArgumentException("Not a valid attribute string value:" + val + ",improper usage of backslash");
            }
            builder.append(chars[i]);
        }
        int len = builder.length();
        if (Rdn.isWhitespace(builder.charAt(len - 1)) && esc != end - 1) {
            builder.setLength(len - 1);
        }
        return builder.toString();
    }

    private static byte[] decodeHexPairs(char[] chars, int beg, int end) {
        byte[] bytes = new byte[(end - beg) / 2];
        int i = 0;
        while (beg + 1 < end) {
            int hi = Character.digit(chars[beg], 16);
            int lo = Character.digit(chars[beg + 1], 16);
            if (hi < 0 || lo < 0) break;
            bytes[i] = (byte)((hi << 4) + lo);
            beg += 2;
            ++i;
        }
        if (beg != end) {
            throw new IllegalArgumentException("Illegal attribute value: " + new String(chars));
        }
        return bytes;
    }

    private static byte[] getUtf8Octets(char[] chars, int beg, int end) {
        byte[] utf8 = new byte[(end - beg) / 3];
        int len = 0;
        while (beg + 2 < end && chars[beg++] == '\\') {
            int hi = Character.digit(chars[beg++], 16);
            int lo = Character.digit(chars[beg++], 16);
            if (hi < 0 || lo < 0) break;
            utf8[len++] = (byte)((hi << 4) + lo);
        }
        if (len == utf8.length) {
            return utf8;
        }
        byte[] res = new byte[len];
        System.arraycopy(utf8, 0, res, 0, len);
        return res;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r';
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.entries = new ArrayList(1);
        String unparsed = (String)s.readObject();
        try {
            new Rfc2253Parser(unparsed).parseRdn(this);
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name: " + unparsed);
        }
    }

    private static class RdnEntry
    implements Comparable {
        private String type;
        private Object value;
        private String comparable = null;

        private RdnEntry() {
        }

        String getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }

        public int compareTo(Object obj) {
            RdnEntry that = (RdnEntry)obj;
            int diff = this.type.compareToIgnoreCase(that.type);
            if (diff != 0) {
                return diff;
            }
            if (this.value.equals(that.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(that.getValueComparable());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RdnEntry)) {
                return false;
            }
            RdnEntry that = (RdnEntry)obj;
            return this.type.equalsIgnoreCase(that.type) && this.getValueComparable().equals(that.getValueComparable());
        }

        public int hashCode() {
            return this.type.toUpperCase(Locale.ENGLISH).hashCode() + this.getValueComparable().hashCode();
        }

        public String toString() {
            return this.type + "=" + Rdn.escapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            this.comparable = this.value instanceof byte[] ? Rdn.escapeBinaryValue((byte[])this.value) : ((String)this.value).toUpperCase(Locale.ENGLISH);
            return this.comparable;
        }
    }
}

