/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.locale.BaseLocale;
import sun.util.locale.Extension;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleUtils;
import sun.util.locale.ParseStatus;
import sun.util.locale.StringTokenIterator;

public class LanguageTag {
    public static final String SEP = "-";
    public static final String PRIVATEUSE = "x";
    public static final String UNDETERMINED = "und";
    public static final String PRIVUSE_VARIANT_PREFIX = "lvariant";
    private String language = "";
    private String script = "";
    private String region = "";
    private String privateuse = "";
    private List<String> extlangs = Collections.emptyList();
    private List<String> variants = Collections.emptyList();
    private List<String> extensions = Collections.emptyList();
    private static final Map<String, String[]> GRANDFATHERED;

    private LanguageTag() {
    }

    public static LanguageTag parse(String string, ParseStatus parseStatus) {
        if (parseStatus == null) {
            parseStatus = new ParseStatus();
        } else {
            parseStatus.reset();
        }
        String[] stringArray = GRANDFATHERED.get(LocaleUtils.toLowerString(string));
        StringTokenIterator stringTokenIterator = stringArray != null ? new StringTokenIterator(stringArray[1], SEP) : new StringTokenIterator(string, SEP);
        LanguageTag languageTag = new LanguageTag();
        if (languageTag.parseLanguage(stringTokenIterator, parseStatus)) {
            languageTag.parseExtlangs(stringTokenIterator, parseStatus);
            languageTag.parseScript(stringTokenIterator, parseStatus);
            languageTag.parseRegion(stringTokenIterator, parseStatus);
            languageTag.parseVariants(stringTokenIterator, parseStatus);
            languageTag.parseExtensions(stringTokenIterator, parseStatus);
        }
        languageTag.parsePrivateuse(stringTokenIterator, parseStatus);
        if (!stringTokenIterator.isDone() && !parseStatus.isError()) {
            String string2 = stringTokenIterator.current();
            parseStatus.errorIndex = stringTokenIterator.currentStart();
            parseStatus.errorMsg = string2.length() == 0 ? "Empty subtag" : "Invalid subtag: " + string2;
        }
        return languageTag;
    }

    private boolean parseLanguage(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isLanguage(string)) {
            bl = true;
            this.language = string;
            parseStatus.parseLength = stringTokenIterator.currentEnd();
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseExtlangs(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isExtlang(string = stringTokenIterator.current())) {
            bl = true;
            if (this.extlangs.isEmpty()) {
                this.extlangs = new ArrayList<String>(3);
            }
            this.extlangs.add(string);
            parseStatus.parseLength = stringTokenIterator.currentEnd();
            stringTokenIterator.next();
            if (this.extlangs.size() != 3) continue;
            break;
        }
        return bl;
    }

    private boolean parseScript(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isScript(string)) {
            bl = true;
            this.script = string;
            parseStatus.parseLength = stringTokenIterator.currentEnd();
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseRegion(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isRegion(string)) {
            bl = true;
            this.region = string;
            parseStatus.parseLength = stringTokenIterator.currentEnd();
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseVariants(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isVariant(string = stringTokenIterator.current())) {
            bl = true;
            if (this.variants.isEmpty()) {
                this.variants = new ArrayList<String>(3);
            }
            this.variants.add(string);
            parseStatus.parseLength = stringTokenIterator.currentEnd();
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseExtensions(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSingleton(string = stringTokenIterator.current())) {
            int n = stringTokenIterator.currentStart();
            String string2 = string;
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSubtag(string = stringTokenIterator.current())) {
                stringBuilder.append(SEP).append(string);
                parseStatus.parseLength = stringTokenIterator.currentEnd();
                stringTokenIterator.next();
            }
            if (parseStatus.parseLength <= n) {
                parseStatus.errorIndex = n;
                parseStatus.errorMsg = "Incomplete extension '" + string2 + "'";
                break;
            }
            if (this.extensions.isEmpty()) {
                this.extensions = new ArrayList<String>(4);
            }
            this.extensions.add(stringBuilder.toString());
            bl = true;
        }
        return bl;
    }

    private boolean parsePrivateuse(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isPrivateusePrefix(string)) {
            int n = stringTokenIterator.currentStart();
            StringBuilder stringBuilder = new StringBuilder(string);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isPrivateuseSubtag(string = stringTokenIterator.current())) {
                stringBuilder.append(SEP).append(string);
                parseStatus.parseLength = stringTokenIterator.currentEnd();
                stringTokenIterator.next();
            }
            if (parseStatus.parseLength <= n) {
                parseStatus.errorIndex = n;
                parseStatus.errorMsg = "Incomplete privateuse";
            } else {
                this.privateuse = stringBuilder.toString();
                bl = true;
            }
        }
        return bl;
    }

    public static LanguageTag parseLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList;
        LanguageTag languageTag = new LanguageTag();
        String string = baseLocale.getLanguage();
        String string2 = baseLocale.getScript();
        String string3 = baseLocale.getRegion();
        String string4 = baseLocale.getVariant();
        boolean bl = false;
        String string5 = null;
        if (LanguageTag.isLanguage(string)) {
            if (string.equals("iw")) {
                string = "he";
            } else if (string.equals("ji")) {
                string = "yi";
            } else if (string.equals("in")) {
                string = "id";
            }
            languageTag.language = string;
        }
        if (LanguageTag.isScript(string2)) {
            languageTag.script = LanguageTag.canonicalizeScript(string2);
            bl = true;
        }
        if (LanguageTag.isRegion(string3)) {
            languageTag.region = LanguageTag.canonicalizeRegion(string3);
            bl = true;
        }
        if (languageTag.language.equals("no") && languageTag.region.equals("NO") && string4.equals("NY")) {
            languageTag.language = "nn";
            string4 = "";
        }
        if (string4.length() > 0) {
            arrayList = null;
            object3 = new StringTokenIterator(string4, "_");
            while (!((StringTokenIterator)object3).isDone() && LanguageTag.isVariant((String)(object2 = ((StringTokenIterator)object3).current()))) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add((String)object2);
                ((StringTokenIterator)object3).next();
            }
            if (arrayList != null) {
                languageTag.variants = arrayList;
                bl = true;
            }
            if (!((StringTokenIterator)object3).isDone()) {
                object2 = new StringBuilder();
                while (!((StringTokenIterator)object3).isDone() && LanguageTag.isPrivateuseSubtag((String)(object = ((StringTokenIterator)object3).current()))) {
                    if (((StringBuilder)object2).length() > 0) {
                        ((StringBuilder)object2).append(SEP);
                    }
                    ((StringBuilder)object2).append((String)object);
                    ((StringTokenIterator)object3).next();
                }
                if (((StringBuilder)object2).length() > 0) {
                    string5 = ((StringBuilder)object2).toString();
                }
            }
        }
        arrayList = null;
        object3 = null;
        if (localeExtensions != null) {
            object2 = localeExtensions.getKeys();
            object = object2.iterator();
            while (object.hasNext()) {
                Character c = object.next();
                Extension extension = localeExtensions.getExtension(c);
                if (LanguageTag.isPrivateusePrefixChar(c.charValue())) {
                    object3 = extension.getValue();
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(c.toString() + SEP + extension.getValue());
            }
        }
        if (arrayList != null) {
            languageTag.extensions = arrayList;
            bl = true;
        }
        if (string5 != null) {
            object3 = object3 == null ? "lvariant-" + string5 : (String)object3 + SEP + PRIVUSE_VARIANT_PREFIX + SEP + string5.replace("_", SEP);
        }
        if (object3 != null) {
            languageTag.privateuse = object3;
        }
        if (languageTag.language.length() == 0 && (bl || object3 == null)) {
            languageTag.language = UNDETERMINED;
        }
        return languageTag;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<String> getExtlangs() {
        if (this.extlangs.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extlangs);
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getVariants() {
        if (this.variants.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.variants);
    }

    public List<String> getExtensions() {
        if (this.extensions.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extensions);
    }

    public String getPrivateuse() {
        return this.privateuse;
    }

    public static boolean isLanguage(String string) {
        int n = string.length();
        return n >= 2 && n <= 8 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isExtlang(String string) {
        return string.length() == 3 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isScript(String string) {
        return string.length() == 4 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isRegion(String string) {
        return string.length() == 2 && LocaleUtils.isAlphaString(string) || string.length() == 3 && LocaleUtils.isNumericString(string);
    }

    public static boolean isVariant(String string) {
        int n = string.length();
        if (n >= 5 && n <= 8) {
            return LocaleUtils.isAlphaNumericString(string);
        }
        if (n == 4) {
            return LocaleUtils.isNumeric(string.charAt(0)) && LocaleUtils.isAlphaNumeric(string.charAt(1)) && LocaleUtils.isAlphaNumeric(string.charAt(2)) && LocaleUtils.isAlphaNumeric(string.charAt(3));
        }
        return false;
    }

    public static boolean isExtensionSingleton(String string) {
        return string.length() == 1 && LocaleUtils.isAlphaString(string) && !LocaleUtils.caseIgnoreMatch(PRIVATEUSE, string);
    }

    public static boolean isExtensionSingletonChar(char c) {
        return LanguageTag.isExtensionSingleton(String.valueOf(c));
    }

    public static boolean isExtensionSubtag(String string) {
        int n = string.length();
        return n >= 2 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isPrivateusePrefix(String string) {
        return string.length() == 1 && LocaleUtils.caseIgnoreMatch(PRIVATEUSE, string);
    }

    public static boolean isPrivateusePrefixChar(char c) {
        return LocaleUtils.caseIgnoreMatch(PRIVATEUSE, String.valueOf(c));
    }

    public static boolean isPrivateuseSubtag(String string) {
        int n = string.length();
        return n >= 1 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static String canonicalizeLanguage(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtlang(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeScript(String string) {
        return LocaleUtils.toTitleString(string);
    }

    public static String canonicalizeRegion(String string) {
        return LocaleUtils.toUpperString(string);
    }

    public static String canonicalizeVariant(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtension(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtensionSingleton(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtensionSubtag(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizePrivateuse(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizePrivateuseSubtag(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.language.length() > 0) {
            stringBuilder.append(this.language);
            for (String string : this.extlangs) {
                stringBuilder.append(SEP).append(string);
            }
            if (this.script.length() > 0) {
                stringBuilder.append(SEP).append(this.script);
            }
            if (this.region.length() > 0) {
                stringBuilder.append(SEP).append(this.region);
            }
            for (String string : this.variants) {
                stringBuilder.append(SEP).append(string);
            }
            for (String string : this.extensions) {
                stringBuilder.append(SEP).append(string);
            }
        }
        if (this.privateuse.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SEP);
            }
            stringBuilder.append(this.privateuse);
        }
        return stringBuilder.toString();
    }

    static {
        String[][] stringArrayArray;
        GRANDFATHERED = new HashMap<String, String[]>();
        for (String[] stringArray : stringArrayArray = new String[][]{{"art-lojban", "jbo"}, {"cel-gaulish", "xtg-x-cel-gaulish"}, {"en-GB-oed", "en-GB-x-oed"}, {"i-ami", "ami"}, {"i-bnn", "bnn"}, {"i-default", "en-x-i-default"}, {"i-enochian", "und-x-i-enochian"}, {"i-hak", "hak"}, {"i-klingon", "tlh"}, {"i-lux", "lb"}, {"i-mingo", "see-x-i-mingo"}, {"i-navajo", "nv"}, {"i-pwn", "pwn"}, {"i-tao", "tao"}, {"i-tay", "tay"}, {"i-tsu", "tsu"}, {"no-bok", "nb"}, {"no-nyn", "nn"}, {"sgn-BE-FR", "sfb"}, {"sgn-BE-NL", "vgt"}, {"sgn-CH-DE", "sgg"}, {"zh-guoyu", "cmn"}, {"zh-hakka", "hak"}, {"zh-min", "nan-x-zh-min"}, {"zh-min-nan", "nan"}, {"zh-xiang", "hsn"}}) {
            GRANDFATHERED.put(LocaleUtils.toLowerString(stringArray[0]), stringArray);
        }
    }
}

