/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;

public class ReadUserKeywordsHashNode
extends RubyNode {
    private final int minArgumentCount;
    @Node.Child
    private DoesRespondDispatchHeadNode respondToToHashNode;
    @Node.Child
    private CallDispatchHeadNode callToHashNode;
    private final ConditionProfile notEnoughArgumentsProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile lastArgumentIsHashProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile respondsToToHashProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile convertedIsHashProfile = ConditionProfile.createBinaryProfile();

    public ReadUserKeywordsHashNode(int minArgumentCount) {
        this.minArgumentCount = minArgumentCount;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int argumentCount = RubyArguments.getArgumentsCount(frame);
        if (this.notEnoughArgumentsProfile.profile(argumentCount <= this.minArgumentCount)) {
            return null;
        }
        Object lastArgument = RubyArguments.getArgument(frame, argumentCount - 1);
        if (this.lastArgumentIsHashProfile.profile(RubyGuards.isRubyHash(lastArgument))) {
            return lastArgument;
        }
        return this.tryConvertToHash(frame, argumentCount, lastArgument);
    }

    private Object tryConvertToHash(VirtualFrame frame, int argumentCount, Object lastArgument) {
        Object converted;
        if (this.respondsToToHashProfile.profile(this.respondToToHash(frame, lastArgument)) && this.convertedIsHashProfile.profile(RubyGuards.isRubyHash(converted = this.callToHash(frame, lastArgument)))) {
            RubyArguments.setArgument(frame, argumentCount - 1, converted);
            return converted;
        }
        return null;
    }

    private boolean respondToToHash(VirtualFrame frame, Object lastArgument) {
        if (this.respondToToHashNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToToHashNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), false));
        }
        return this.respondToToHashNode.doesRespondTo(frame, "to_hash", lastArgument);
    }

    private Object callToHash(VirtualFrame frame, Object lastArgument) {
        if (this.callToHashNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callToHashNode = this.insert(CallDispatchHeadNode.createMethodCall());
        }
        return this.callToHashNode.call(frame, lastArgument, "to_hash", new Object[0]);
    }
}

