/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.highlight.TermVectorLeafReader;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class TermVectorOffsetStrategy
extends FieldOffsetStrategy {
    public TermVectorOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        super(field, queryTerms, phraseHelper, automata);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
    }

    @Override
    public List<OffsetsEnum> getOffsetsEnums(IndexReader reader, int docId, String content) throws IOException {
        Terms tvTerms = reader.getTermVector(docId, this.field);
        if (tvTerms == null) {
            return Collections.emptyList();
        }
        TermVectorLeafReader leafReader = null;
        if (this.terms.length > 0 || this.strictPhrases.willRewrite()) {
            leafReader = new TermVectorLeafReader(this.field, tvTerms);
            docId = 0;
        }
        TokenStream tokenStream = null;
        if (this.automata.length > 0) {
            tokenStream = MultiTermHighlighting.uninvertAndFilterTerms(tvTerms, 0, this.automata, content.length());
        }
        return this.createOffsetsEnums(leafReader, docId, tokenStream);
    }
}

