/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class JoinProcessor
extends AbstractProcessor {
    public static final String TYPE = "join";
    private final String field;
    private final String separator;

    JoinProcessor(String tag, String field, String separator) {
        super(tag);
        this.field = field;
        this.separator = separator;
    }

    String getField() {
        return this.field;
    }

    String getSeparator() {
        return this.separator;
    }

    public void execute(IngestDocument document) {
        List list = (List)document.getFieldValue(this.field, List.class);
        if (list == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot join.");
        }
        String joined = list.stream().map(Object::toString).collect(Collectors.joining(this.separator));
        document.setFieldValue(this.field, (Object)joined);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public JoinProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)JoinProcessor.TYPE, (String)processorTag, config, (String)"field");
            String separator = ConfigurationUtils.readStringProperty((String)JoinProcessor.TYPE, (String)processorTag, config, (String)"separator");
            return new JoinProcessor(processorTag, field, separator);
        }
    }
}

