/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.CronExpression;

@Plugin(name="CronTriggeringPolicy", category="Core", printObject=true)
@Scheduled
public final class CronTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final String defaultSchedule = "0 0 0 * * ?";
    private RollingFileManager manager;
    private final CronExpression cronExpression;
    private final Configuration configuration;
    private final boolean checkOnStartup;
    private volatile Date nextRollDate;
    private CronScheduledFuture<?> future;

    private CronTriggeringPolicy(CronExpression schedule, boolean checkOnStartup, Configuration configuration) {
        this.cronExpression = schedule;
        this.configuration = configuration;
        this.checkOnStartup = checkOnStartup;
    }

    @Override
    public void initialize(RollingFileManager aManager) {
        this.manager = aManager;
        Date nextDate = new Date(this.manager.getFileTime());
        this.nextRollDate = this.cronExpression.getNextValidTimeAfter(nextDate);
        if (this.checkOnStartup && this.nextRollDate.getTime() < System.currentTimeMillis()) {
            this.rollover();
        }
        this.future = this.configuration.getScheduler().scheduleWithCron(this.cronExpression, new CronTrigger());
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        return false;
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    @PluginFactory
    public static CronTriggeringPolicy createPolicy(@PluginConfiguration Configuration configuration, @PluginAttribute(value="evaluateOnStartup") String evaluateOnStartup, @PluginAttribute(value="schedule") String schedule) {
        CronExpression cronExpression;
        boolean checkOnStartup = Boolean.parseBoolean(evaluateOnStartup);
        if (schedule == null) {
            LOGGER.info("No schedule specified, defaulting to Daily");
            cronExpression = CronTriggeringPolicy.getSchedule(defaultSchedule);
        } else {
            cronExpression = CronTriggeringPolicy.getSchedule(schedule);
            if (cronExpression == null) {
                LOGGER.error("Invalid expression specified. Defaulting to Daily");
                cronExpression = CronTriggeringPolicy.getSchedule(defaultSchedule);
            }
        }
        return new CronTriggeringPolicy(cronExpression, checkOnStartup, configuration);
    }

    private static CronExpression getSchedule(String expression) {
        try {
            return new CronExpression(expression);
        }
        catch (ParseException pe) {
            LOGGER.error("Invalid cron expression - " + expression, (Throwable)pe);
            return null;
        }
    }

    private void rollover() {
        this.manager.getPatternProcessor().setPrevFileTime(this.nextRollDate.getTime());
        this.manager.rollover();
        Date fireDate = this.future.getFireTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(fireDate);
        cal.add(13, -1);
        this.nextRollDate = cal.getTime();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = this.stop(this.future);
        this.setStopped();
        return stopped;
    }

    public String toString() {
        return "CronTriggeringPolicy(schedule=" + this.cronExpression.getCronExpression() + ")";
    }

    private class CronTrigger
    implements Runnable {
        private CronTrigger() {
        }

        @Override
        public void run() {
            CronTriggeringPolicy.this.rollover();
        }
    }
}

