/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.queries.function.FunctionValues;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.expression.ReplaceableConstFunctionValues;

public class ExpressionExecutableScript
implements ExecutableScript {
    private final int NO_DOCUMENT = -1;
    public final CompiledScript compiledScript;
    public final Map<String, ReplaceableConstFunctionValues> functionValuesMap;
    public final ReplaceableConstFunctionValues[] functionValuesArray;

    public ExpressionExecutableScript(CompiledScript compiledScript, Map<String, Object> vars) {
        this.compiledScript = compiledScript;
        Expression expression = (Expression)this.compiledScript.compiled();
        int functionValuesLength = expression.variables.length;
        if (vars.size() != functionValuesLength) {
            throw new GeneralScriptException("Error using " + compiledScript + ". The number of variables in an executable expression script [" + functionValuesLength + "] must match the number of variables in the variable map [" + vars.size() + "].");
        }
        this.functionValuesArray = new ReplaceableConstFunctionValues[functionValuesLength];
        this.functionValuesMap = new HashMap<String, ReplaceableConstFunctionValues>();
        for (int functionValuesIndex = 0; functionValuesIndex < functionValuesLength; ++functionValuesIndex) {
            String variableName = expression.variables[functionValuesIndex];
            this.functionValuesArray[functionValuesIndex] = new ReplaceableConstFunctionValues();
            this.functionValuesMap.put(variableName, this.functionValuesArray[functionValuesIndex]);
        }
        for (String varsName : vars.keySet()) {
            this.setNextVar(varsName, vars.get(varsName));
        }
    }

    public void setNextVar(String name, Object value) {
        if (this.functionValuesMap.containsKey(name)) {
            if (!(value instanceof Number)) {
                throw new GeneralScriptException("Error using " + this.compiledScript + ". Executable expressions scripts can only process numbers.  The variable [" + name + "] is not a number.");
            }
        } else {
            throw new GeneralScriptException("Error using " + this.compiledScript + ". The variable [" + name + "] does not exist in the executable expressions script.");
        }
        double doubleValue = ((Number)value).doubleValue();
        this.functionValuesMap.get(name).setValue(doubleValue);
    }

    public Object run() {
        try {
            return ((Expression)this.compiledScript.compiled()).evaluate(-1, (FunctionValues[])this.functionValuesArray);
        }
        catch (Exception exception) {
            throw new GeneralScriptException("Error evaluating " + this.compiledScript, (Throwable)exception);
        }
    }
}

