/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.function.Consumer;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;

public class ActiveShardsObserver
extends AbstractComponent {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ActiveShardsObserver(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void waitForActiveShards(final String indexName, final ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, this.logger, this.threadPool.getThreadContext());
        if (activeShardCount.enoughShardsActive(observer.observedState(), indexName)) {
            onResult.accept(true);
        } else {
            ClusterStateObserver.ValidationPredicate shardsAllocatedPredicate = new ClusterStateObserver.ValidationPredicate(){

                @Override
                protected boolean validate(ClusterState newState) {
                    return activeShardCount.enoughShardsActive(newState, indexName);
                }
            };
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    ActiveShardsObserver.this.logger.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)indexName);
                    onFailure.accept(new NodeClosedException(ActiveShardsObserver.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

