/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;

public class FilteredCollector
implements Collector {
    private final Collector collector;
    private final Weight filter;

    public FilteredCollector(Collector collector, Weight filter) {
        this.collector = collector;
        this.filter = filter;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        Scorer filterScorer = this.filter.scorer(context);
        LeafCollector in = this.collector.getLeafCollector(context);
        final Bits bits = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorer);
        return new FilterLeafCollector(in){

            public void collect(int doc) throws IOException {
                if (bits.get(doc)) {
                    this.in.collect(doc);
                }
            }
        };
    }

    public boolean needsScores() {
        return this.collector.needsScores();
    }
}

