/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

class DictionaryEditDialog
extends JDialog {
    private final JList list;
    private final JButton delete;
    private boolean isModify;

    DictionaryEditDialog(JDialog jDialog) {
        super(jDialog, Utils.getResource("userDictionary"), true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        DefaultListModel defaultListModel = new DefaultListModel();
        this.loadWordList(defaultListModel);
        this.list = new JList(defaultListModel);
        container.add((Component)new JScrollPane(this.list), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.delete = Utils.getButton("delete");
        container.add((Component)this.delete, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 8, 8, 8), 0, 0));
        DeleteAction deleteAction = new DeleteAction();
        this.delete.addActionListener(deleteAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(127, 0, false), "DELETE");
        this.getRootPane().getActionMap().put("DELETE", deleteAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DictionaryEditDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        String string = this.getTitle();
        int n = this.getFontMetrics(this.getFont()).stringWidth(string) + 80;
        if (dimension.width < n) {
            dimension.width = n;
        }
        return dimension;
    }

    private void loadWordList(DefaultListModel defaultListModel) {
        Iterator<String> iterator;
        UserDictionaryProvider userDictionaryProvider = SpellChecker.getUserDictionaryProvider();
        if (userDictionaryProvider != null && (iterator = userDictionaryProvider.getWords(SpellChecker.getCurrentLocale())) != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string == null || string.length() <= 1) continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList, Collator.getInstance());
            for (String string : arrayList) {
                defaultListModel.addElement(string);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.isModify) {
            Object object;
            Object object2;
            UserDictionaryProvider userDictionaryProvider = SpellChecker.getUserDictionaryProvider();
            if (userDictionaryProvider != null) {
                object2 = this.list.getModel();
                object = new StringBuilder();
                for (int i = 0; i < object2.getSize(); ++i) {
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append('\n');
                    }
                    ((StringBuilder)object).append(object2.getElementAt(i));
                }
                userDictionaryProvider.setUserWords(((StringBuilder)object).toString());
            }
            object2 = SpellChecker.createLanguagesMenu(null);
            object = ((JMenu)object2).getMenuComponents();
            for (Component component : object) {
                JRadioButtonMenuItem jRadioButtonMenuItem;
                if (!(component instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)component).isSelected()) continue;
                jRadioButtonMenuItem.doClick();
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DictionaryEditDialog.this.list.getSelectedIndices();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)DictionaryEditDialog.this.list.getModel()).remove(nArray[i]);
                DictionaryEditDialog.this.isModify = true;
            }
        }
    }
}

