/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.listeners;

import freemind.controller.MindMapNodesSelection;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;

public class MindMapNodeDropListener
implements DropTargetListener {
    private final MindMapController mMindMapController;

    public MindMapNodeDropListener(MindMapController controller) {
        this.mMindMapController = controller;
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        if (ev.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        return ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        MindMapNode node = ((MainView)event.getDropTargetContext().getComponent()).getNodeView().getModel();
        MindMapNode selected = this.mMindMapController.getSelected();
        if (!node.isWriteable()) {
            return false;
        }
        return node != selected && !node.isDescendantOf(selected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        block16: {
            try {
                int dropAction = dtde.getDropAction();
                Transferable t = dtde.getTransferable();
                MainView mainView = (MainView)dtde.getDropTargetContext().getComponent();
                NodeView targetNodeView = mainView.getNodeView();
                MindMapNode targetNode = targetNodeView.getModel();
                MindMapNodeModel targetNodeModel = (MindMapNodeModel)targetNode;
                if (dtde.isLocalTransfer() && t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
                    String sourceAction = (String)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
                    if (sourceAction.equals("LINK")) {
                        dropAction = 0x40000000;
                    }
                    if (sourceAction.equals("COPY")) {
                        dropAction = 1;
                    }
                }
                mainView.setDraggedOver(0);
                mainView.repaint();
                if (dtde.isLocalTransfer() && dropAction == 2 && !this.isDropAcceptable(dtde)) {
                    dtde.rejectDrop();
                    return;
                }
                dtde.acceptDrop(dtde.getDropAction());
                if (!dtde.isLocalTransfer()) {
                    this.mMindMapController.paste(t, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                    dtde.dropComplete(true);
                    return;
                }
                if (dropAction == 0x40000000) {
                    MindMapMapModel mindMapMapModel = (MindMapMapModel)this.mMindMapController.getModel();
                    int yesorno = 0;
                    if (this.mMindMapController.getView().getSelecteds().size() >= 5) {
                        yesorno = JOptionPane.showConfirmDialog(this.mMindMapController.getFrame().getContentPane(), this.mMindMapController.getText("lots_of_links_warning"), Integer.toString(this.mMindMapController.getView().getSelecteds().size()) + " links to the same node", 0);
                    }
                    if (yesorno == 0) {
                        ListIterator it = this.mMindMapController.getView().getSelecteds().listIterator();
                        while (it.hasNext()) {
                            MindMapNodeModel selectedNodeModel = (MindMapNodeModel)((NodeView)it.next()).getModel();
                            this.mMindMapController.addLink(selectedNodeModel, targetNodeModel);
                        }
                    }
                    break block16;
                }
                if (!targetNode.isWriteable()) {
                    String message = this.mMindMapController.getText("node_is_write_protected");
                    JOptionPane.showMessageDialog(this.mMindMapController.getFrame().getContentPane(), message, "Freemind", 0);
                    return;
                }
                Transferable trans = null;
                List selecteds = this.mMindMapController.getSelecteds();
                if (2 != dropAction) {
                    trans = this.mMindMapController.copy();
                } else {
                    MindMapNode actualNode = targetNode;
                    do {
                        if (!selecteds.contains(actualNode)) continue;
                        String message = this.mMindMapController.getText("cannot_move_to_child");
                        JOptionPane.showMessageDialog(this.mMindMapController.getFrame().getContentPane(), message, "Freemind", 2);
                        dtde.dropComplete(true);
                        return;
                    } while ((actualNode = actualNode.isRoot() ? null : actualNode.getParentNode()) != null);
                    trans = this.mMindMapController.cut();
                }
                this.mMindMapController.getView().selectAsTheOnlyOneSelected(targetNodeView);
                boolean result = this.mMindMapController.paste(trans, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                if (!result && 2 != dropAction) {
                    // empty if block
                }
            }
            catch (Exception e) {
                System.err.println("Drop exception:" + e);
                Resources.getInstance().logException(e);
                dtde.dropComplete(false);
                return;
            }
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        boolean repaint;
        MainView draggedNode = (MainView)e.getDropTargetContext().getComponent();
        int oldDraggedOver = draggedNode.getDraggedOver();
        draggedNode.setDraggedOver(e.getLocation());
        int newDraggedOver = draggedNode.getDraggedOver();
        boolean bl = repaint = newDraggedOver != oldDraggedOver;
        if (repaint) {
            draggedNode.repaint();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView draggedNode = (MainView)e.getDropTargetContext().getComponent();
        draggedNode.setDraggedOver(0);
        draggedNode.repaint();
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

