#
# This file is part of:
#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
# Copyright (c) 1998-2013 Miguel Filgueiras migfilg@t-online.de
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 3 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langes.tcl
#  Last change:  6 October 2013
#
# Spanish language file by Alberto Morales (amd77 _AT_ gulic.org)
#  last input from him: 21 September 2011
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file i18n-utf8.tcl
set MONTHNAMES "Ene Feb Mar Abr May Jun Jul Ago Sep Oct Nov Dic"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) km2
set DLUNIT(NAUTMILE,dist) "ml mar"
set DLUNIT(NAUTMILE,subdist) pie
set DLUNIT(NAUTMILE,speed) nudos
set DLUNIT(NAUTMILE,area) "ml2"
set DLUNIT(STATMILE,dist) "ml ter"
set DLUNIT(STATMILE,subdist) pie
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) "seccin"

set DLUNIT(M,dist) $DLUNIT(KM,subdist)
set DLUNIT(FT,dist) $DLUNIT(STATMILE,subdist)

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ARUNIT $DLUNIT($DISTUNIT,area)
set ALUNIT $DLUNIT($ALTUNIT,dist)

set MESS(RTcomp) "#\tPT\t\t$DTUNIT\tgrados\t$ALUNIT"
set MESS(TRcomp) "#\t\t\t\t$ALUNIT\t$DTUNIT\t$DTUNIT\th:m:s\t$SPUNIT\tgrados"
set MESS(WPNearest) "PT\t\t$DTUNIT\tgrados"

array set MESS {
    badscale   "Valor incorecto para la escala del mapa"
    oktoexit   "Ok para terminar (datos no guardados se perdern)"
    okclrmap   "Ok para borrar el mapa"
    namelgth   "Nombre no puede tener ms de %d caracteres"
    cmmtlgth   "Comentario no puede tener ms de %d caracteres"
    namevoid   "Nombre no puede ser vaco"
    baddate   "Fecha incorrecta; linea"
    badhdg   "Direccin incorrecta %s: debe ser %s o +/-"
    badcoord "Coordenada con valor o formato incorrecto: \"%s\" debe ser %s"
    outofrng   "Nmero fuera de lmites"
    UTMZN   "Debe ser una letra entre A..H, J..N, o P..Z"
    badstrg   "Caracter(es) incorrecto(s)"
    strgvoid   "Cadena debe tener por lo menos un caracter"
    nan   "\"%s\" no es un nmero"
    written   "Escrito por"
    undefWP   "Ruta %s tiene puntos no definidos; no guardada/exportada"
    bigRT   "Ruta %s > mximo permitido; no exportada"
    unkndatum   "Datum desconocido"
    badcommdWP   "Comando incorrecto al leer puntos; lnea"
    notabsWP   "Punto mal definido (sin tabuladores); lnea"
    undefinedWP   "Referencia a punto desconocido: %s"
    undefinedTR   "Trayecto desconocido"
    nofieldsWP   "Punto mal definido (faltan campos); lnea"
    excfieldsWP  "Punto mal definido (demasiados campos); lnea"
    badWPsRT   "Ruta con lista incorrecta de puntos; lnea"
    toomuchWPs   "Aviso: mas de %d puntos en ruta"
    badcommdTP   "Comando incorrecto a leer puntos de trayecto; lnea"
    badcommdLP   "Comando incorrecto a leer puntos de punto de linea; lnea"
    badTP   "Punto incorrecto en trayecto; lnea"
    badTPsTR   "Trayecto con lista incorrecta de puntos; lnea"
    badLP   "Punto incorrecto en lnea; lnea"
    badLPsLN   "Lnea con lista de puntos incorrecta; lnea"
    noheader   "Fichero no tiene cabecera"
    loaderr   "Error al leer fichero; lnea"
    unkncommd   "Comando desconocido al leer fichero; lnea"
    noformat   "Fichero no comienza con lnea de formato"
    badformat   "Especificacin de formato incorrecta"
    badRT   "Ruta mal especificada; lnea"
    badRTargs   "Parmetros incorrectos para ruta; lnea"
    badTR   "Trayecto mal especificado; lnea"
    fileact   "%s fichero (%s)"
    filexists   "Fichero existente!"
    GPSok   "Conexin correcta"
    toomany   "Demasiados %ss (> %d)"
    cantfgt   "No puedo olvidar %s: pertenece a algo dibujado"
    cantfgted   "No puedo olvidar %s: est siendo editado"
    cantmapRTunkn   "Ruta no dibujada; punto desconocido"
    cantmapRTed   "Ruta no dibujada; punto en edicin"
    cantrun   "No puedo ejecutar"
    inprogr   "Operacin ya iniciada"
    cantread   "No puedo leer del fichero auxiliar"
    cantwrtopt   "No puedo escribir en el fichero de opciones"
    voidRT   "Ruta sin puntos"
    activeRT   "Ruta 0 es la ruta activa; continuar?"
    voidTR   "Trayecto sin puntos"
    voidLN   "Lnea sin puntos"
    idinuse   "Identificador ya est siendo usado"
    cantunmap   "Imposible desvincular %s; pertence a objeto dibujado"
    askrevert   "Volver a datos inciales?"
    askforget   "Olvidarse de este %s?"
    notimpl   "No implementado"
    forgetall   "Olvidar toda la lista de %ss?"
    counted   "Hay %d %ss en la lista"
    notlisted   "Elemento no est en la lista"
    wrgval   "Valor incorrecto para"
    voidGR   "Grupo no tiene elementos"
    initselfGR   "Grupo contiene a si mismo a travs de"
    GRelout   "Comando para elemento fuera de definicin de GR; lnea"
    badGRels   "Grupo con lista de elementos incorrecta; lnea"
    badcommdGRel   "Comando incorrecto al leer elementos de grupo; lnea"
    notypeforGRel   "Elemento sin tipo; lnea"
    badGRel   "Definicin de elemento incorrecta; lnea"
    check   "Intentando conectar"
    toomanyerr   "Demasiados errores; cancelando..."
    getWP   "Recibiendo Puntos"
    getRT   "Recibiendo Rutas"
    getTR   "Recibiendo Trayectos"
    getLAP  "Recibiendo Vueltas"
    getAL   "Recibiendo almanaque"
    putWP   "Enviando Puntos"
    putRT   "Enviando Rutas"
    putTR   "Enviando Trayectos"
    fillbuffWP  "Cargando conjunto de puntos"
    fillbuffRT  "Cargando conjunto de rutas"
    noACKNAK  "Recibido paquete en vez de ACK/NAK; verifique la conexin con el GPS"
    badplatform   "Esta plataforma no permite E/S con el puerto serie"
    badserial "No puedo acceder al puerto serie %s"
    nodata    "El receptor no tiene %ss"
    badimage "Fichero de imagen incorrecto"
    mapadjust "Coloque los puntos en el mapa; pulse Ok al acabar"
    duplicate "%s ya elegido"
    clrcurrmap "Borrar mapa existente?"
    mbkbaddatum "Sin datum vlido"
    mbkbadscale "La escala no puede ser negativa"
    mbkbadat "Argumentos incorrectos"
    edityourrisk "Edite bajo su responsabilidad!"
    okclrbkmap   "Ok para borrar fondo del mapa"
    okclrbkim   "Ok para borrar imagen en"
    badattrval "Campo opcional invlido (%s): %s"
    badattr "Nombre de campo opcional desconocido (%s): %s"
    badSYMBOLcode "Cdigo de smbolo incorrecto"
    badDISPOPTcode "Cdigo de forma de mostrar incorrecto"
    goingdown "Opciones guardadas; por favor reinicie"
    putwhat "Colocar qu tipos de datos?"
    readwhat "Leer que tipos de datos?"
    noWPinx "Demasiados puntos para el receptor"
    noICinx "Demasiados ICs para el receptor"
    getIC "Recibiendo iconos"
    serial1 "Prembulo de cabecera incorrecto"
    serial2 "Recibido comando incorrecto"
    checksum1 "Suma de verificacin de cabecera incorrecta"
    checksum2 "Suma de verificacin de datos incorrecta"
    receiver "No se ha establecido conexin serie!" 
    importonly1 "Slo puede importar 1 tipo de datos"
    exportonly1 "Slo puede exportar 1 tipo de datos"
    outdatedprefs "Fichero de opciones tiene que ser actualizado"
    mustchoose1type "Seleccione al menos 1 tipo de datos"
    nosuchitems "Ningn elemento tiene esa descripcin"
    resultsin "Resultados en el Grupo"
    badWP "Falta punto por definir"
    badangle "ngulo debe ser >0 y <360 grados"
    georefhow  "Mtodo para geo-referenciar"
    cantsolve  "Ecuaciones sin solucin"
    transfcantscale "Transformacin actual no permite alterar escala"
    oldfilefmt "Formato antiguo; por favor, guardar con formato nuevo!"
    unknProj "Proyeccin desconocida"
    unknTransf "Transformacin desconocida"
    badProjargs "Parmetros de proyeccin incorrectos"
    badTransfargs "Parmetros de transformacin incorrectos"
    badfield "Pareja atributo=valor incorrecta"
    badattr "Nombre de atributo incorrecto"
    missattrs "Faltan atributo(s)"
    mbkbadproj "Proyeccin incorrecta"
    mbkbadtransf "Transformacin incorrecta"
    notUTMproj "Informacin salvada para UTM; continuar con proyeccin"
    projchg    "Confirme parmetros de proyeccin"
    badparam "Valor incorrecto para %s"
    connectedto "Conectado a %s"
    recnotsuppd "Modelo de receptor no reconocido"
    gotprots "Recibida informacin sobre protocolos"
    badprots "Informacin sobre protocolos incorrecta"
    defprots "Usando tabla de protocolos"
    nohidden "Descartar datos ocultos?"
    badRS "Etapa de ruta fuera de definicin de RT; lnea"
    badWPsRSs "Etapa de ruta antes del primer o despus del ltimo punto; lnea"
    windowdestr "La ventana ha sido destruida!"
    badhidden "Formato incorrecto del valor oculto"
    replname "Substituya \"%s\" por un nombre que tenga al menos %d de los siguientes caracteres: %s"
    badalt "Valor incorrecto para altitud"
    baddistunit "Unidad de distancia incorrecta para escala de mapa en opciones"
    badgridzone "Cuadrcula incorrecta"
    outofgrid "Posicin fuera de la cuadrcula"
    timeoffnotint "Diferencia horaria debe ser entera"
    cantchkprot "Este protocolo no permite verificacin"
    mustconn1st "Primero verifique la conexin con el receptor"
    rltmnotsupp "Este protocolo en este receptor no permite registro en tiempo real"
    createdir "Necesita crear directorio %s y reiniciar"
    oktomkdir "Puedo crear el directorio %s?"
    projnameabbr "Por favor, dar un nombre y una abreviatura para la nueva proyeccin"
    abbrevinuse "Abreviatura ya usada"
    nameinuse "Nombre ya usado"
    projinuse "Proyeccin est siendo usada; los cambios no tendrn efecto"
    gridneedsdatum "Definicin incorrecta de cuadrcula %s; datum por definir"
    badgriddatum "El datum para la cuadrcula %s debe ser %s"
    cantchggriddatum "Esta cuadrcula debe usar el datum %s"
    gridinuse "Cuadrcula usada por %s, no puede borrarse; continuar?"
    gridinusenochg "Cuadrcula usada por %s; cambios sin efecto"
    cantwrtprgr "No puedo escribir en fichero de proyecciones"
    cantwrtdtel "No puedo escribir en fichero de datums"
    movingWP "Colocar %s con botn izquierdo\nCancelar con botn derecho"
    missingdata "Informacin insuficiente!"
    needs1wp "Una ruta debe tener al menos 1 punto"
    emptypos "Posicin con campo(s) vaco(s)"
    cantwrtsstate "No puedo escribir el fichero de estado: %s"
    cantrdsstate "No puedo leer del fichero de estado: %s"
    corruptsstate "Fichero de estado %s con errores"
    editrisk "Edite bajo su responsabilidad!"
    savestate "Guardar estado actual?"
    delsstate "Borrar ficheros de estado?"
    badmapinfo "Error en fichero de parmetros de mapa"
    badMHloc "Posicin Maidenhead incorrecta"
    areais "rea del polgono (no intersectado): %.3f%s"
    areatoosmall "rea es demasiado pequea (<%s km2)"
    projarea "Calculando rea proyectada"
    selfintsct "Puntos repetidos: una ruta no puede intersectarse!"
    badinvmdist "Error de aproximacin al invertir distancia sobre meridiano"
    badinvproj "Error de aproximacin al invertir la proyeccin %s"
    negdlatlong "Diferencia entre lat/long no puede ser negativa!"
    allundef "No hay definiciones para los puntos del GR"
    badfloats "Hay errores en las conversiones de nmeros decimales; conectar as mismo?"
    noprintcmd "Falta comando para imprimir; definirlo en las opciones"
    cantexecasroot "GPSMan no puede ser ejecutado por root"
    badargtofunc "Argumento incorrecto a la funcin %s"
    redefproj "Abreviatura de proyeccin %s coincide con una proyeccin predefinida; renombre su definicin!"
    couldntcd "Imposible cambiarse al directorio %s"
    shpext "Extensin %s incorrecta; ok para usar .shp, .shx, .dbf?"
    shpcntopen "Imposible crear/abrir ficheros Shapefile"
    shpcntcrtfs "Imposible crear campos Shapefile .dbf"
    shpcntwrtfs "Imposible escribir campos Shapefile .dbf"
    shpoutmem "Memoria agotada!"
    shpemptyfile "Fichero vaco"
    shpwrongfile "Tipo de fichero incorrecto"
    shplessdim "Dimensin en fichero menor que la solicitada; continuar?"
    shpbadWPinRT "WP nmero %d de coordenadas incorrectas ignorado en RT %s"
    errorGTMread "Error al leer de fichero de GTrackMaker"
    badGTMvers "Versin no soportada de fichero de GTrackMaker"
    badGTMfile "Inicio incorrecto de fichero de GTrackMaker"
    badGTMcounts "Contador(es) negativos en fichero de GTrackMaker"
    badGTMlat "Latitud incorrecta en fichero de GTrackMaker"
    badGTMlong "Longitud incorrecta en fichero de GTrackMaker"
    badGTMdatum "Datum invlido en fichero de GTrackMaker"
    unobscmap "Error tal vez por haber una ventana/icono sobre el mapa; esperar y volver a intentar?"
    cantwrtimg "Error al guardar imagen a fichero en formato %s"
    cantsaveRTid "%d ruta(s) no guardada: identificador no numrico"
    cantsaveTRid "%d trayecto(s) no guardado: identificador no numrico"
    badtrvconf "Configuracin inconsistente sustituida por una vaca"
    drvsimoff "Simulador de conduccin: falta iniciar!"
    needWP "Simulador de conduccin: es preciso definir puntos antes"
    chgrecprot "Por favor, seleccionar otro protocolo de receptor"
    clrtrvlog "Borrar registro de viaje?"
    frgetGRcs "Olvidar grupo y todos sus elementos?!"
    nmeainuse "Ya se est capturando registro en tiempo real, o se esta leyendo otro fichero NMEA"
    badfile "Error al leer desde fichero"
    RTnoWPname "Los puntos de ruta slo con nombre han dejado de estar soportados"
    distlarge "Distancia demasiado grande!"
    convres "%s resultado de conversin creado con el nombre %s"
    outrngproj "Punto no puede ser proyectado!"
    badconv "Error en la conversin del parmetro %s: %s"
    badprmval "Resultado errneo en la conversin del parmetro %s: %s"
    timeconsmg "La operacin puede durar mucho tiempo: seguir?"
    badtimeval "Valor incorrecto para la hora"
    badLAP "LAP incorrecto; lnea"
    lapncnsdrd "LAP no se toma en cuenta"
    undefinedTR   "Trayecto desconocido"
    emptymenu "Men vacio; continuar?"
    cantwrtsymenu "No puedo escribir en fichero de men de smbolos"
    abbrevhasspaces "El nombre corto no puede tener espacios"
    needNpoints "Debes dar al menos %s puntos!"
    twotimeoffsets "Varias diferencias horarias en el fichero"
    notimeoffset "Falta diferencia horaria en el fichero; usar 0"
    baddateas "Fecha incorrecta: %s"
    unknownenc "Codificacin de caracteres desconocida %s"
    chgbaudto "Cambiando velocidad transmisin para %s; por favor espere..."
    busytrylater "Otras operaciones en curso; intntelo ms tarde"
    baudchgfailed "No puedo cambiar velocidad transmisin"
    obssplit "Resultados de cortar %s llamado \"%s\""
    samelgth "Las dos secuencias deben ser del mismo tamao"
    rschkargs "La llamada a regsub di error; verifique los argumentos"
    emptyrmeth "Mtodo de substitucin no puede ser vaco"
    cantwrtdefs "No puedo escribir el fichero de definicin de usuarios"
    xcantbey "%s no puede ser %s"
    mustselftfam "Tiene que seleccionar una familia de fuentes"
    badpluginwhere "Error en argumento \"where\" de complemento; debe ser una lista de triplas"
    badpluginparam "Error en parmetros de complemento: lista de NAME EXPR, NAME comienza por _"
    badpluginparamexec "Al ejecutar el complemento %s, parmetro incorrecto: %s"
    pluginfailed "Complemento %s fall con mensaje: %s"
    loginto "Acceso a %s"
    cantwrtdir "No puedo escribir en %s; por favor arregle los permisos"
    cantcleandir "No pude vaciar el directorio %s"
    defTERMCMD "La opcion para el comando que abre una ventana de terminal debe ser definida primero"
    gpOutfile "La salida est en el fichero \"%s\" del directorio de trabajo."
    gpQuitgnuplot "Pulse Enter en la ventana de xterm para salir de gnuplot."
    gpModgnuplot "Modifique la vista en la ventana de Gnuplot\
                  arrastrndo con el ratn (botn izquierdo y derecho).\n\
                  Despues de cerrar la ventana de Gnuplot encontrar\
                  la salida en el fichero \"%s\" del directorio de trabajo."
    htResult1 "Trayecto=\"%s\""
    htResult2 "Distancia total=%s  Ascenso total=%s  Descenso total=%s"
    htResult3 "Tiempo total=%s  Tiempo de descanso=%s(%s)  Tiempo en movimiento=%s"
    htResult4 "%s  Cap.plano=%s  Cap.asc=%s  Cap.desc=%s  Tiempo senderismo estimado=%s"
    srResult1 "Periodos de descanso (>5min) en el trayecto \"%s\""
}

set TXT(RTcompflds) "# PT {$DTUNIT} grados {$ALUNIT} etapa etiq"
set TXT(TRcompflds) \
    "PTS {} {} {} {$ALUNIT} {$DTUNIT} {$DTUNIT} h:m:s {$SPUNIT} grados"
set TXT(starttoend) "Inicio: hasta fin %s $DTUNIT;"
set TXT(startmax) "mx %s $DTUNIT;"
set TXT(WPnearflds) "PT {$DTUNIT} grados"
set TXT(within) "Hasta (${DTUNIT}s)"
set TXT(between) "Entre (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - versin"
    exit   Salir
    map   Mapa
    load   Leer
    loadfrm   "Leer de"
    save   Guardar
    saveels "Guardar elementos"
    saveto   "Guardar a"
    clear   Limpiar
    clearall   "Limpiar todo"
    newWP   "Nuevo punto"
    newRT   "Nueva ruta"
    newTR   "Nuevo trayecto"
    newLN   "Nueva lnea"
    newGR   "Nuevo grupo"
    import   Importar
    importfrm   "Importar de"
    export   Exportar
    exportels "Exportar elementos"
    exportto   "Exportar a"
    count   Contar
    trueN   "Norte Geograf"
    automagn   "Declin Auto"
    usrdef   "Def Usuario"
    nameWP   Punto
    nameRT   Ruta
    nameTR   Trayecto
    nameLN   Lnea
    nameLP   "Punto de lnea"
    nameGR   Grupo
    namePlot   Grfico
    nameMap   Mapa
    nameRTComp   "Clculo de Ruta"
    nameTRComp   "Clculo de Trayecto"
    nameInfo Informacin
    GPSrec   "Receptor GPS"
    turnoff   Apagar
    get   Buscar
    put   Colocar
    all   Todo
    select   Escoger
    selection   Eleccin
    options   Opciones
    DMS   GMS
    DMM   GMM
    DDD   GGG
    GRA   Grados
    message   Mensaje
    cancel   Cancelar
    file   Fichero
    ovwrt   Sobreescribir
    app   Anexar
    online   "en lnea"
    offline   "fuera de lnea"
    check   Comprobar
    create   Crear 
    revert   Releer
    colour   color
    grey   gris
    mono   mono
    portr   horizontal
    landsc   apaisado
    legend   Leyenda
    incscale   "Inclur escala"
    more   "(ms.)"
    waypoint   Punto
    name   Nombre
    created   "Creado en"
    cmmt   Comentario
    withWP  "Con este punto:"
    displ   "Mostrar en mapa"
    startRT "Iniciar ruta"
    route   Ruta
    number   Nmero
    numberid "Nmero/Id"
    insb   "Insertar antes"
    insa   "Insertar despus"
    del   Borrar
    repl   "Sustituir por"
    comp   Calcular
    RTcomp   "Clculo de ruta"
    savecomp "Guardar clculos"
    totdst   "Distancia total"
    tottime   "Tiempo total"
    totdstng   "Distancia total, sin huecos"
    tottimeng  "Tiempo total, sin huecos"
    totresttime  "Tiempo total de descanso (>5min)"
    avgspmot  "Velocidad media en movimiento"
    track   Trayecto
    chophd   "Borrar cabecera"
    choptl   "Borrar cola"
    incb   "Incluir antes"
    date   Fecha
    newdate   "Nueva fecha para el punto siguiente"
    endprTR   "Fin del trayecto anterior"
    begnxt   "Inicio del siguiente"
    date1st   "Fecha para el primer punto del siguiente"
    TRcomp   "Clculos para trayecto"
    avgsp   "Veloc media"
    maxsp   "Veloc mx"
    minsp   "Veloc mn"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   x
    nrthng   y
    zone   Zona
    change   Cambiar
    forget   Olvidar
    others   Otros
    opt_Interf "Interfaz de usuario"
    optLANG   Idioma
    optISOLATIN1   "Acentos y smbolos"
    optDELETE   "DEL borra ltimo caracter"
    optMWINDOWSCONF  "Ventana principal"
    optSERIALBAUD "Velocidad transmisin"
    optGPSREC   "Modelo de GPS"
    opt_GPSRecConf   "Parmetros del receptor"
    optACCEPTALLCHARS "Aceptar cualquier carcter"
    optNAMELENGTH   "Longitud mx nombre"
    optINTERVAL "Intervalo de muestreo"
    optCOMMENTLENGTH   "Longitud mx comentarios"
    optMAXWPOINTS   "N mx de puntos"
    optMAXROUTES   "N mx de rutas"
    optMAXWPINROUTE   "N mx de puntos en ruta"
    optMAXTPOINTS   "N mx de puntos en trayecto"
    optCREATIONDATE   "Receptor tiene fecha de creacin"
    optNOLOWERCASE   "Receptor no tiene minsculas"
    optDEFAULTSYMBOL "Smbolo habitual de punto"
    optDEFAULTDISPOPT "Forma habitual de mostrar punto"
    opt_Data "Datos"
    optEQNAMEDATA "Datos con el mismo nombre"
    optKEEPHIDDEN "Mantener datos ocultos"
    optDatum   Datum
    optTimeOffset   "Dif horaria"
    optACCFORMULAE "Frmulas de mayor precisin"
    optASKPROJPARAMS "Confirmar parmetros de proyeccin"
    optBalloonHelp "Globos de ayuda"
    optTRNUMBERINTVL "Mostrar informacin de punto de trayecto cada"
    optTRINFO "Informacin de punto de trayecto a mostrar"
    opt_Formats   "Unidades y formatos"
    optDISTUNIT   "Distancia"
    optALTUNIT "Altura"
    optUSESLOWOPWINDOW "Ventana para controlar operaciones lentas"
    optDEFTRECPROTOCOL "Protocolo por defecto"
    optLNSREACT "LNs asociadas responden al ratn"
    NAUTMILE    "milla nutica"
    STATMILE    "milla terrestre"
    FT    pie
    optPositionFormat   "Formato para posiciones"
    optDateFormat   "Formato para fechas"
    opt_Geom   "Geometra de ventanas"
    opt_MapGeom   "Geometra de mapa"
    optMAPWIDTH   "Ancho del mapa"
    optMAPHEIGHT   "Alto del mapa"
    optMAPSCLENGTH   "Longitud escala de mapa"
    optMAPSCALE   "Escala de mapa"
    optMAXMENUITEMS   "N mx de items en menu"
    optLPOSX   "Pos horiz ventana de listas"
    optLPOSY   "Pos vert ventana de listas"
    optMPOSX   "Pos horiz ventana de mapa"
    optMPOSY   "Pos vert ventana de mapa"
    optRPOSX   "Pos horiz ventana de receptor"
    optRPOSY   "Pos vert ventana de receptor"
    optEPOSX   "Pos horiz ventana de error"
    optEPOSY   "Pos vert ventana de error"
    optDPOSX   "Pos horiz dilogo"
    optDPOSY   "Pos vert dilogo"
    optDPOSRTMAP "Ajuste ventana RT/mapa"
    optLISTWIDTH   "Anchura de lista"
    optLISTHEIGHT   "Altura de lista"
    optCOLOUR   Colores
    optCOLOUR,fg   Frente
    optCOLOUR,bg   Fondo
    optCOLOUR,messbg   "Fondo para error"
    optCOLOUR,confbg   "Fondo para confirmacin"
    optCOLOUR,selbg   "Fondo para seleccin"
    optCOLOUR,dialbg   "Fondo para preguntas"
    optCOLOUR,offline   "Receptor fuera de lnea"
    optCOLOUR,online   "Receptor en lnea"
    optCOLOUR,check   "Seleccionado botn"
    optCOLOUR,ballbg   "Fondo para ayuda"
    optCOLOUR,ballfg   "Frente para ayuda"
    optMAPCOLOUR  "Colores de mapa"
    optMAPCOLOUR,mapsel   "Item seleccionado en mapa"
    optMAPCOLOUR,WP   "Puntos en mapa"
    optMAPCOLOUR,RT   "Rutas en mapa"
    optMAPCOLOUR,mkRT "Ruta definida en mapa"
    optMAPCOLOUR,TR   "Trayectos en mapa"
    optMAPCOLOUR,TP   "Puntos de trayecto en mapa"
    optMAPCOLOUR,LN   "Lneas en mapa"
    optMAPCOLOUR,mapleg   "Legendas en mapa"
    optMAPCOLOUR,anim "Animacin en mapa"
    optMAPCOLOUR,emptygrid  "Sin imagen"
    optMAPCOLOUR,fullgrid   "Con imagen"
    opt_Fonts "Tipos de letra"
    optDEFTRTWIDTH "Grosor lnea ruta"
    optDEFTTRWIDTH "Grosor lnea trayecto"
    optDEFTLNWIDTH "Grosor lnea lnea"
    opt_Files "Puerto serie y ficheros"
    optDEFSPORT "Puerto serie"
    optSAVESTATE "Guardar estado al salir"
    optDELSTATE "Borrar ficheros de estado"
    optPERMS   "Permisos de fichero"
    optPRINTCMD "Comando para imprimir"
    optPAPERSIZE "Tamao de papel"
    optMapGuideVersion "Versin de MapGuide"
    optICONSIZE "Tamao de iconos"
    red   Rojo
    green   Verde
    blue   Azul
    owner   Propietario
    permgroup   Grupo
    others   Otros
    fread   Leer
    fwrite   Escr
    fexec   Ejec
    YYYYMMDD   AAAAMMDD
    MMDDYYYY   MMDDAAAA
    DDMMMYYYY   DDMMMAAAA
    YYYY-MM-DD  AAAA-MM-DD
    YYYY/MM/DD  AAAA/MM/DD
    mainwd   "Ventana principal"
    distazim   "Dist y azimut"
    nearestWPs   "puntos prximos"
    fromto   "Desde %s hasta %s"
    degrees   grados
    nameWPDistBear   "dist y azimut"
    nameWPNearest   "puntos prximos"
    inrect   "En rectngulo"
    forthisWP   "para este punto"
    formappedWPs   "para puntos en mapa"
    group   Grupo
    element   Elemento
    insert   Insertar
    joinGR   "Juntar Grupo"
    TRtoRT   "Conversin de tray a ruta"
    TRtoLN   "Conversion de tray a lnea"
    TRtoTR   "Simplificacin de trayecto"
    TRRTnpoints   "N de puntos a mantener"
    TRlinedispl   "Mostrar resultados"
    TRTRdispl   "Mostrar trayecto"
    WP   PT
    TP   PT
    LP   PL
    LAP  LAP
    commrec   "Comunicacin con receptor"
    abort   Desistir
    ACKs   ACKs
    NAKs   NAKs
    packets   paquetes
    unnamed   "(por definir)"
    fromTR    "Desde tray: %s"
    mapload "Geo-ref imagen"
    loadmback Leer
    savemback "Guardar info geo-ref"
    chgmback Cambiar
    clearmback Limpiar
    backgrnd Fondo
    nameMapBkInfo "Info sobre fondo"
    nameMapInfo "Parmetros del mapa"
    mpbkchg "Cambiar fondo"
    mpbkgrcs "Posicin de rejilla"
    nameImage Imagen
    symbol Smbolo
    SY1st_aid "Primeros auxilios"
    SYCATaviation Aviacin
    SYCATgeneral Genrico
    SYCATland Terrestre
    SYCATwater Aqutico
    SYMOB "Hombre al agua"
    SYRV_park "Parque de vehculos recreativos"
    SYWP_buoy_white "Boya, blanca"
    SYWP_dot "Punto"
    SYairport "Aeropuerto"
    SYamusement_park "Parque de atracciones"
    SYanchor "Ancla"
    SYanchor_prohib "Ancla prohibida"
    SYavn_danger "Peligro (avn)"
    SYbait_tackle "Cebo y aparejo"
    SYball "Bola"
    SYbeach "Playa"
    SYbeacon "Baliza"
    SYbell "Campana"
    SYbiker "Ciclista"
    SYboat "Barco"
    SYboat_ramp "Rampa para barcos"
    SYborder "Frontera"
    SYbot_cond "Condiciones fondo"
    SYbowling "Bolera"
    SYbox_blue "Caja, azul"
    SYbox_green "Caja, verde"
    SYbox_red "Caja, roja"
    SYbridge "Puente"
    SYbuilding "Edificio"
    SYbuoy_amber "Boya, mbar"
    SYbuoy_black "Boya, negra"
    SYbuoy_blue "Boya, azul"
    SYbuoy_green "Boya, verde"
    SYbuoy_green_red "Boya, verde roja"
    SYbuoy_green_white "Boya, verde blanca"
    SYbuoy_orange "Boya, naranja"
    SYbuoy_red "Boya, roja"
    SYbuoy_red_green "Boya, roja verde"
    SYbuoy_red_white "Boya, roja blanca"
    SYbuoy_violet "Boya, violeta"
    SYbuoy_white "Boya, blanca"
    SYbuoy_white_green "Boya, blanca verde"
    SYbuoy_white_red "Boya, blanca roja"
    SYcamping "Camping"
    SYcapitol_city "Ciudad, estrella"
    SYcar "Automovil"
    SYcar_rental "Alquiler de automoviles"
    SYcar_repair "Taller de automovil"
    SYcasino "Casino"
    SYcastle "Castillo"
    SYcemetery "Cementerio"
    SYchapel "Capilla"
    SYchurch "Iglesia"
    SYcircle_blue "Crculo, azul"
    SYcircle_green "Crculo, verde"
    SYcircle_red "Crculo, rojo"
    SYcircle_x "Crculo con X"
    SYcivil "Instalacin civil"
    SYcntct_afro "Afro"
    SYcntct_alien "Alien"
    SYcntct_ball_cap "Pelota beisbol"
    SYcntct_big_ears "Orejas grandes"
    SYcntct_biker "Ciclista"
    SYcntct_bug "Cucaracha"
    SYcntct_cat "Gato"
    SYcntct_dog "Perro"
    SYcntct_dreads "Trencitas"
    SYcntct_female1 "Hembra 1"
    SYcntct_female2 "Hembra 2"
    SYcntct_female3 "Hembra 3"
    SYcntct_goatee "Perilla"
    SYcntct_kung_fu "Kung fu"
    SYcntct_pig "Cerdo"
    SYcntct_pirate "Pirata"
    SYcntct_ranger "Ranger"
    SYcntct_smiley "Sonriente"
    SYcntct_spike "Clavo"
    SYcntct_sumo "Sumo"
    SYcoast_guard "GuardaCostas"
    SYcontrolled "Area controlada"
    SYcross "Mira"
    SYcross_3p "Mira 3p"
    SYcrossing "Cruce"
    SYdam "Presa"
    SYdanger "Peligro"
    SYdeer "Ciervo"
    SYdiamond_blue "Rombo, azul"
    SYdiamond_green "Diamante, verde"
    SYdiamond_red "Diamante, rojo"
    SYdiver_down_1 "Buceo 1"
    SYdiver_down_2 "Buceo 2"
    SYdock "Drsena"
    SYdollar "Dolar"
    SYdot "Punto"
    SYdrinking_water "Agua potable"
    SYdropoff "Embarcadero"
    SYduck "Pato"
    SYelevation "Punto alto"
    SYexit "Salida"
    SYexit_no_serv "Salida sin servicios"
    SYfactory "Fbrica"
    SYfastfood "Comida rpida"
    SYfhs_facility "Instalacin FHS"
    SYfish "Pez"
    SYfitness "Gimnasia"
    SYflag "Bandera"
    SYflag_pin_blue "Alfiler con bandera, azul"
    SYflag_pin_green "Alfiler con bandera, verde"
    SYflag_pin_red "Alfiler con bandera, rojo"
    SYfreeway "Autova"
    SYfuel "Gasolinera"
    SYfuel_store "Gasolinera & tienda"
    SYgeo_name_land "Nombre geogr, tierra"
    SYgeo_name_man "Nombre geogr, hombre"
    SYgeo_name_water "Nombre geogr, agua"
    SYgeocache "Geocache"
    SYgeocache_fnd "Geocache encontrada"
    SYglider "Ala delta"
    SYgolf "Golf"
    SYheliport "Helipuerto"
    SYhorn "Claxon"
    SYhouse "Casa"
    SYhouse_2 "Casa 2"
    SYhydrant "Boca de riego"
    SYice_skating "Patinaje sobre hielo"
    SYinfo "Informacin"
    SYintersection "Interseccin"
    SYis_highway "Autopista"
    SYknife_fork "Comida"
    SYladder "Escalera"
    SYlanding "Aterrizaje"
    SYlarge_city "Ciudad (grande)"
    SYlarge_exit_ns "Salida sin servicio (grande)"
    SYlarge_ramp_int "Cruce con barreras (grande)"
    SYletter_a_blue "A, azul"
    SYletter_a_green "A, verde"
    SYletter_a_red "A, rojo"
    SYletter_b_blue "B, azul"
    SYletter_b_green "B, verde"
    SYletter_b_red "B, rojo"
    SYletter_c_blue "C, azul"
    SYletter_c_green "C, verde"
    SYletter_c_red "C, rojo"
    SYletter_d_blue "D, azul"
    SYletter_d_green "D, verde"
    SYletter_d_red "D, rojo"
    SYlevee "Dique"
    SYlight "Faro"
    SYlodging "Alojamento"
    SYmany_fish "Banco de peces"
    SYmany_tracks "Muchos caminos"
    SYmarina "Marina"
    SYmark_x "Marca, x"
    SYmedium_city "Ciudad, media"
    SYmile_marker "Punto kilomtrico"
    SYmilitary "Instalaciones militares"
    SYmine Mina
    SYmonument "Monumento"
    SYmountains "Montaas"
    SYmovie "Cine"
    SYmug "Jarra"
    SYmuseum "Museo"
    SYntl_highway "Autopista nacional"
    SYnull "(transparente)"
    SYnull_2 "(vaco)"
    SYnumber_0_blue "0, azul"
    SYnumber_0_green "0, verde"
    SYnumber_0_red "0, rojo"
    SYnumber_1_blue "1, azul"
    SYnumber_1_green "1, verde"
    SYnumber_1_red "1, rojo"
    SYnumber_2_blue "2, azul"
    SYnumber_2_green "2, verde"
    SYnumber_2_red "2, rojo"
    SYnumber_3_blue "3, azul"
    SYnumber_3_green "3, verde"
    SYnumber_3_red "3, rojo"
    SYnumber_4_blue "4, azul"
    SYnumber_4_green "4, verde"
    SYnumber_4_red "4, rojo"
    SYnumber_5_blue "5, azul"
    SYnumber_5_green "5, verde"
    SYnumber_5_red "5, rojo"
    SYnumber_6_blue "6, azul"
    SYnumber_6_green "6, verde"
    SYnumber_6_red "6, rojo"
    SYnumber_7_blue "7, azul"
    SYnumber_7_green "7, verde"
    SYnumber_7_red "7, rojo"
    SYnumber_8_blue "8, azul"
    SYnumber_8_green "8, verde"
    SYnumber_8_red "8, rojo"
    SYnumber_9_blue "9, azul"
    SYnumber_9_green "9, verde"
    SYnumber_9_red "9, rojo"
    SYoil_field "Campo de petrleo"
    SYopen_24hr "Abierto 24h"
    SYoval_blue "Oval, azul"
    SYoval_green "Oval, verde"
    SYoval_red "Oval, rojo"
    SYparachute "Paracadas"
    SYpark "Parque"
    SYparking "Aparcamiento"
    SYpharmacy "Farmacia"
    SYphone "Telfono"
    SYpicnic "Picnic"
    SYpin_blue "Alfiler, azul"
    SYpin_green "Alfiler, verde"
    SYpin_red "Alfiler, rojo"
    SYpizza "Pizzera"
    SYpolice "Polica"
    SYpost_office "Correos"
    SYprivate "Campo privado"
    SYradio_beacon "Radio baliza"
    SYramp_int "Cruce con barreras" 
    SYrect_blue "Bloque, azul"
    SYrect_green "Bloque, verde"
    SYrect_red "Bloque, rojo"
    SYreef "Arrecife"
    SYrestricted "Area restringida"
    SYrestrooms "WC"
    SYscenic "Paisaje"
    SYschool "Colegio"
    SYseaplane "Base de hidroaviones"
    SYshopping_cart "Centro comercial"
    SYshort_tower "Torre, baja"
    SYshowers "Duchas"
    SYskiing "Esqu acutico"
    SYskull "Calavera"
    SYsmall_city "Ciudad, pequea"
    SYsnow_skiing "Esqu de montaa"
    SYsoft_field "Campo suave"
    SYsquare_blue "Cuadrado, azul"
    SYsquare_green "Cuadrado, verde"
    SYsquare_red "Cuadrado, rojo"
    SYst_highway "Autopista estatal"
    SYstadium "Estdio"
    SYstore "Tienda"
    SYstreet_int "Cruce de calles"
    SYstump "Tocn"
    SYsummit "Pico"
    SYswimming "Natacin"
    SYtake_off "Despegar"
    SYtall_tower "Torre, alta"
    SYtheater Teatro
    SYtide_pred_stn "Estacin prediccin mareas/corrientes"
    SYtoll Peaje
    SYtow_truck "Camin-gra"
    SYtraceback "Regreso"
    SYtracks "Caminos"
    SYtrail_head "Inicio de camino"
    SYtree "rbol"
    SYtriangle_blue "Tringulo, azul"
    SYtriangle_green "Tringulo, verde"
    SYtriangle_red "Tringulo, rojo"
    SYtruck_stop "Parada de camiones"
    SYtunnel "Tnel"
    SYultralight "Ultra-ligero"
    SYus_highway "Autopista EEUU"
    SYweedbed "Lecho de algas"
    SYweight_station Bscula
    SYwreck "Naufragio"
    SYzoo "Zoolgico"
    psvisible "Slo la parte visible"
    DISPsymbol "Slo smbolo"
    DISPs_name "Simb & nombre"
    DISPs_comment "Simb & comentario"
    DISPname "Slo nombre"
    DISPcomment "Slo comentario"
    dispopt Mostrar
    mapitems "Mostrar en mapa"
    nameIC Icono
    prod Producto
    WPCapac "Mximo de Puntos"
    ICCapac "Mximo de Iconos"
    RTCapac "Mximo de Rutas"
    TRCapac "Mximo de Trayectos"
    protcl "Protocolo"
    ICGraph "Smbolos para iconos"
    WPperRT "Puntos por ruta"
    notinGR "no en (sub-)grupo"
    onlyinGR "slo en (sub-)grupo"
    loadgrels "Leer elementos"
    importgrels "Importar elementos"
    about "Sobre GPSMan..."
    contrib "Con contribuciones de"
    errorsto "En caso de errores, contactar:"
    obsTRToRT "puntos creados por conversin de tray a ruta"
    obsTRsimpl "Trayecto obtenido por simplificacin"
    nameLists "Listas"
    nameData "Datos"
    MWCmap "Mapa"
    MWClists "Listas"
    MWCsingle "Ventana nica"
    search "Buscar"
    rmrk "Notas"
    closeto "Prximo a"
    with "Con"
    srchres "ENCONTRADOS"
    database "Base de datos"
    where "Dnde"
    what "Qu"
    list "lista"
    distance "Distancia"
    fromWP "del Punto"
    fromPos "de posicin"
    azimuth "Azimut"
    any "cualquier"
    opening "Abriendo"
    suggested "sugerido"
    another "Otro"
    srchdd1 "Buscar en"
    srchdd2Data "todos los datos"
    srchdd2GR "Grupo(s)"
    from "de"
    started "iniciado en"
    transf  "Transf Coords"
    TRNSFAffine    "Afn"
    TRNSFAffineConf  "Afn Conforme"
    TRNSFNoRot      "Conf sin Rot"
    projection "Proyeccin"
    lat0  "Lat central"
    long0 "Long central"
    lat1  "Lat 1 paralelo"
    lat2  "Lat 2 paralelo"
    latF  "Lat falso origen"
    longF "Long falso origen"
    k0 "Factor de escala"
    PRJUTM "UTM/UPS"
    PRJTM "Transversal de Mercator"
    PRJBMN "Cuadrcula Austriaca BMN"
    PRJBNG "Cuadrcula Nac Britnica"
    PRJBWI "ndias Occid Britnicas"
    PRJCMP "Carta Militar Portugal"
    PRJCTR "Carta Tecnica Reg (I)"
    PRJITM "Cuadrcula TM Irlandesa"
    PRJGKK "Cuadrcula Alemana"
    PRJLCC1 "Lambert Cnica Conf 1"
    PRJLCC2 "Lambert Cnica Conf 2"
    PRJKKJP "Cuadrcula Finlandesa Base"
    PRJKKJY "Cuadrcula Finlandesa Unif"
    PRJSEG "Cuadrcula Sueca"
    PRJMerc1 "Mercator 1"
    PRJMerc2 "Mercator 2"
    PRJCS "Cassini-Soldner"
    PRJAPOLY "Policnica Americana"
    PRJStereogr "Estereogrfica"
    PRJTWG "Cuadrcula de Taiwan"
    PRJSOM "Oblcua de Mercator Suiza"
    PRJLV03 "Cuadrcula Suiza LV03"
    PRJIcG "Cuadrcula Islandesa"
    PRJRDG "Cuadrcula Holandesa"
    PRJSchreiber Schreiber
    PRJSphMerc "Mercator Esfrica"
    PRJEqCyl "Cilndrica Equidistante"
    dontaskagain "Dejar de preguntar"
    rename "Usar nombre diferente"
    oname "Nombre original"
    never "Nunca"
    ask "Preguntar"
    always "Siempre"
    stage "Etapa"
    label "Etiqueta"
    alt "Altura"
    locate "Encontrar"
    animation  Animacin
    fast Rpido
    slow Lento
    start Inicio
    pause Pausa
    speed Velocidad
    centred "Mantener centrado"
    state Estado
    animinit "al inicio/final"
    animon "en curso"
    animpause "pausado"
    animabort "saliendo"
    realtimelog "Registro de trayectos en tiempo real"
    garmin Garmin
    garmin_usb "Garmin USB"
    nmea "NMEA 0183"
    stext "Texto simple"
    simul "simulador"
    lowrance Lowrance
    magellan Magellan
    getlog Capturar
    stop Parar
    dolog Registrar
    show Mostrar
    hide Esconder
    posfixerror erro
    posfix_  ?
    posfix2D 2D
    posfix3D 3D
    posfix2D-diff "2D d"
    posfix3D-diff "3D d"
    posfixGPS GPS
    posfixDGPS DGPS
    posfixAuto ok
    posfixsimul simul
    restart Recomenzar
    mkTR "Crear trayecto"
    PVTflds "# t lat long alt fix EPE EPH EPV vel_x vel_y vel_z TRK"
    namePVTData Registrar
    mkavgWP "Crear punto promedio"
    move Mover
    define Definir
    open Abrir
    defs "Definiciones"
    baseproj "Proyeccin de base"
    abbrev Abreviatura
    grid Cuadrcula
    use Usar
    unit Unidad
    feasting "Dist E falsa"
    fnorthing "Dist N falsa"
    bounds "Lmites"
    max "Mx"
    min "Mn"
    easting "Dist E"
    northing "Dist N"
    fixeddatum "datum obligatorio"
    elevation "Perfil"
    usewps "Usar puntos"
    chgpfrmt "Cambiar formato posiciones"
    here Aqu
    atprevwp "En punto anterior"
    prevwp "punto anterior"
    firstwp "Primer punto"
    chglstrs "Editar etapa anterior"
    chgnxtrs "Editar etapa siguiente"
    contnend "Aadir al final"
    closemenu "Cerrar menu"
    ellpsd Elipsoide
    datum Datum
    userdefs "Definiciones propias"
    edmap "Editar sobre mapa"
    actual actual
    rtimelogintv "Intervalo de registro"
    inca "Incluir despus"
    invert "Invertir"
    recwindow "Ventana de receptor"
    volume "Volumen"
    latS "Lat S"
    latN "Lat N"
    longW "Long W"
    longE "Long E"
    no No
    computations Clculos
    comparea "Calcular rea"
    cluster Vecinos
    centre  Centro
    mkclusters "Agrupar vecinos"
    quadr Quadrngulo
    dlat "Diferencia en latitud"
    dlong "Diferencia en longitud"
    collcntr "Determinando centros..."
    compclstr "Calculando vecinos..."
    crtgclstrgrs "Creando grupos..."
    chgdatum "Cambiar datum..."
    print Imprimir
    prevctr "Centro anterior"
    printopt "Opciones de impresin"
    cwpsdef "PTs de control para definir ahora"
    nextTP "Prximo punto trayecto"
    generate Generar
    generateall "Generar todo"
    width Grosor
    simplTRto "Simplificar a"
    exstglog "Registro existente"
    contnsly "Continuamente"
    animate "animar"
    chgmfsize "Cambiar tamao fuente mapa"
    animabbrev "anim."
    noanabbr "no anim."
    zelev "inclinacin Z"
    xyelev "inclinacin XY"
    notext "sin leyendas"
    view "Vista"
    sideview "Vista lateral"
    persptv "Perspectiva"
    optMAPCOLOUR,trvtrk "Flecha TRK"
    optMAPCOLOUR,trvtrn "Flechas TRN"
    optMAPCOLOUR,trvcts "Flecha CTS"
    optMAPCOLOUR,trvcts2 "2a flecha CTS"
    optMAPCOLOUR,trvvel_z "Flecha para arriba/abajo"
    optMAPCOLOUR,trvwrnimportant "Aviso importante (nav)"
    optMAPCOLOUR,trvwrnnormal "Aviso (nav)"
    optMAPCOLOUR,trvwrninfo "Informacin (nav)"
    optTRAVELFONTSIZE "Tamao de fuente para viaje"
    travel Viaje
    notravel "Fin de viaje"
    travdisplay "Configurar presentacin"
    travchgdisplay "Cambiar a presentacin %s"
    travdsetup "Configurar presentacin de viaje"
    navMOB "Hombre al agua (MOB)!"
    startnav "Navegar"
    navWP "Ir a punto"
    goback "Regresar"
    follow "Seguir %s"
    exactly "exactamente"
    fromnrst "del punto mas cercano"
    inrvrs "en sentido contrario"
    forgetgoal "Olvidar objetivo"
    suspend "Suspender"
    resume "Recomenzar"
    TRVfix "Fix"
    TRVhour "Tiempo"
    TRVspeed "Veloc"
    TRVpos "Pos"
    TRValt "Alt"
    TRVtrk "TRK"
    TRVnxtWP "Para"
    TRVprvWP "De"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "CTS"
    TRVtrn "TRN"
    TRVvel_z "Vel vert"
    TRVtrkcts "TRK, CTS"
    TRVdist "Dist"
    TRVc_trkcts "Flechas TRK/CTS"
    TRVc_trn "Flechas TRN"
    TRVc_vel_z "Flechas cima/baixo"
    add "Aadir"
    addlabelled "Aadir con nombre"
    remove "Eliminar"
    mindist "Distancia de llegada"
    chggoal "Pasar a siguiente objetivo"
    chginggoal "Cambiando a siguiente objetivo"
    chggoalhlp "Cuando cambiar de un\nobjetivo al siguiente\nmientras se sigue ruta/tray"
    soon pronto
    late tarde
    warnings "Avisos"
    dowarn "Mostrar avisos"
    warnconf "Configurar avisos"
    priority Prioridad
    high alta
    medium media
    low baja
    warnprox "Distancia a punto <"
    warnanchor "Distancia a punto >"
    warnspeed "Velocidad >"
    warntrn "TRN (abs)>"
    warnvspeed "Vel vertical"
    warnxtk "XTK (abs)>"
    fntsize "Tamao de fuente"
    trvhlpbox "Usar botn derecho para reordenar los elementos de abajo"
    trvhlpbxs "Usar botn derecho para reordenar los elementos de la lista"
    trvwarrv "Llegando a %s!"
    trvwleave "Saliendo de %s!"
    trvwspeed "Velocidad > %s!"
    trvwtrn "TRN > %s!"
    trvwvspeed "Vel vert fuera de [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Registro en tiempo real detenido!"
    trvwnopos "Posiciones anteriores no disponibles"
    trvwuwps "Ruta tiene puntos (s) no definidos"
    trvwchg "Yendo ahora hacia %s"
    drivesim "simulador de conduccin"
    startfrom "Comenzar de..."
    outofctrl "Fuera de control!"
    right Derecha
    left Izquierda
    straight "De frente"
    rthlpdsim "Teclas de flecha: girar, des/acelerar\nEspacio: de frente"
    hiddendata "Datos ocultos"
    Ghidden_class Clase
    Ghidden_subclass Subclase
    Ghidden_lnk_ident "Id etapa"
    Ghidden_colour Color
    Ghidden_attrs Atributos
    Ghidden_depth Profundidad
    Ghidden_state Estado
    Ghidden_country Pas
    Ghidden_facility Facility
    Ghidden_city Ciudad
    Ghidden_addr Direccin
    Ghidden_int_road "Cruce de vas"
    Ghidden_dtyp "Mostrar+tipo"
    Ghidden_ete "ETE"
    Ghidden_display "Mostrar?"
    Ghidden_yes S
    Ghidden_no No
    Ghidden_user "Usuario"
    Ghidden_user_symbol "Usuario (slo smbolo)"
    Ghidden_non_user "Interno"
    Ghidden_avn_airport "Aeropuerto"
    Ghidden_avn_inters "Interseccin (av)"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR "VOR"
    Ghidden_avn_airp_rway "Lmite de pista (aeropuerto)"
    Ghidden_avn_airp_int "Interseccin (aeropuerto)"
    Ghidden_avn_airp_NDB "NDB (aeropuerto)"
    Ghidden_map_pt "Punto (mapa)"
    Ghidden_map_area "rea (mapa)"
    Ghidden_map_int "Interseccin (mapa)"
    Ghidden_map_addr "Direccin (mapa)"
    Ghidden_map_line "Lnea (mapa)"
    Ghidden_locked Bloqueado
    Ghidden_default "Normal"
    Ghidden_black Negro
    Ghidden_white Blanco
    Ghidden_red Rojo
    Ghidden_dark_red "Rojo oscuro"
    Ghidden_green Verde
    Ghidden_dark_green "Verde oscuro"
    Ghidden_blue Azul
    Ghidden_dark_blue "Azul oscuro"
    Ghidden_yellow Amarillo
    Ghidden_dark_yellow "Amarillo oscuro"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Magenta oscuro"
    Ghidden_cyan Cyan
    Ghidden_dark_cyan "Cyan oscuro"
    Ghidden_light_gray "Gris claro"
    Ghidden_dark_gray "Gris oscuro"
    Ghidden_transparent Transparente
    Ghidden_line Lnea
    Ghidden_link Etapa
    Ghidden_net Red
    Ghidden_direct Directo
    Ghidden_snap "Discreto(snap)"
    Ghidden_temp Temperatura
    Ghidden_time "Marca de tiempo"
    Ghidden_cat Categora
    renres "NUEVO NOMBRE"
    forgetGRcs "Olvidar grupo"
    optDEFMAPPROJ "Proyeccin de mapa"
    optDEFMAPPFRMT "Coordenadas del mapa"
    optDEFMAPPFDATUM "Datum de coordenadas del mapa"
    undo Deshacer
    UTMzone zona
    tfwfile  "fichero TFW"
    ok Ok
    newWPatdb "Nuevo punto hacia..."
    PRJLamb93 "Lambert 93"
    PRJLambNTFe "NTF IIet"
    PRJLambNTF "NTF"
    NTFzone zona
    loop "Ciclar"
    crtLN "Crear lnea"
    PRJAEA "Albers Equivalente"
    PRJLEAC "Lambert Eq Cnica"
    PRJTAlbers "Teale Albers"
    polasp "Aspecto polar"
    north Norte
    south Sur
    distunit "Unidad de distancia"
    altunit "Unidad de altitud"
    params "Argumentos"
    dimens "Dimensiones"
    version "Versin"
    opinprogr "Realizando operacin"
    working "Ejecutando"
    aborted "Abortado!"
    errwarn "Error(es)/aviso(s)!"
    changegroupsymbol "Cambiar smbolo"
    ozimapfile "fichero Ozi Map"
    info "Informacin"
    climbrate "Ritmo de Ascenso"
    BGAfeature  "BGA Caracterstica"
    BGAfindblty "BGA Encontrabilidad"
    BGAairact   "BGA Actividad aerea"
    dispitems "Elementos mostrados"
    hiditems "Elementos ocultos"
    mkgrp "Crear Grupo"
    optAutoNumRts "Numerar Rutas automticamente al enviar"
    numberfrom0 "Configurar contador a 0"
    items "Elementos"
    optSUPPORTLAPS "Soporte para Vueltas"
    nameLAP "Vuelta"
    duration "Duracin"
    calrs "Caloras"
    syusrmenu "Personalizar men de smbolo"
    cfgsymenu "Configurar men de smbolo"
    insmnb   "Inserta submen antes"
    insmna   "Inserta submen despus"
    opensbmn "Abrir submen"
    clssbmn  "Cerrar submen"
    syhlpbx "Usar botn derecho para\nreordenar los elementos de la lista"
    lapsrun Correr
    fromfile "desde fichero"
    fromdef "desde definicin"
    mbaktoload "Fondo para cargar"
    none "ninguno"
    nameAL "Almanaque"
    alm_svid "id satlite"
    alm_week "semana"
    alm_datatime "tiempo ref datos"
    alm_clockc1 "cpef corr reloj s"
    alm_clockc2 "coef corr reloj s/s"
    alm_ecc "excentricidad"
    alm_sqrta "raiz cuadr a"
    alm_mnanom "anomala promedio"
    alm_argprgee "arg perigeo"
    alm_rightasc "ascensin recta"
    alm_rtrightasc "veloc ascensin r"
    alm_inclin "inclinacin"
    alm_health "salud"
    lstsqs "Mnimos cuadrados"
    lstsqsfile  "Fichero de Mnimos cuadrados"
    mapfitWPs "Mostrar puntos de ajuste en mapa"
    showfitinfo "Mostrar informacin de ajuste"
    xtcoord "xt"
    ytcoord "yt"
    delta   "d"
    residual "rt"
    rmsxydev "media_cuadr(x,y-desviaciones)"
    resstderr "erro std residual"
    chgdev "Cambiar puerto"
    alt_cumula "Ascenso acumulado"
    alt_cumuld "Descenso acumulado"
    maxalt "Altitud mxima"
    minalt "Altitud mnima"
    optSHOWFILEITEMS "Normalmente mostrar en mapa elementos leidos"
    vertgridlines "Rejilla vertical"
    convert  "Convertir"
    split    "Cortar"
    bysel  "por puntos seleccionados"
    byseg  "en segmentos"
    openits "Abrir %s"
    chgname "Sustituir nombres"
    clicktoedit "Pulsar para editar"
    renamethod "Mtodo de renombrado"
    operators "Operadores"
    keep1st "mantener primer caracter"
    keep1st_hlp "Mantener primer caracter\noperaciones siguientes en caracteres restantes"
    reset "recomenzar"
    reset_hlp "Recomenzar con nombre inicial deshaciendo cambios anteriores"
    case "may/minsculas"
    case_hlp "Todas las letras en maysuclas/minsculas"
    maxlgth "mxima longitud"
    maxlgth_hlp "Limitar nmero de caracteres a nmero"
    inslt "insertar por la izquierda"
    inslt_hlp "La cadena a insertar antes del actual caracter"
    insrt "insertar por la derecha"
    insrt_hlp "La cadena a insertar al final"
    replc "sustituir"
    replc_hlp "Cada caracter en la primera cadena ser sustituido por\nel correspondiente en la segunda"
    delany "borrar todos"
    delany_hlp "Todos los caracteres en la cadena sern borrados del nombre"
    rsub "sutitucin con expr.reg"
    rsub_hlp "Dar expr.reg y especificacin de sustitucin\nMs detalles en manual"
    accifnew "aceptar si nuevo"
    accifnew_hlp "Aceptar resultado si es un nombre nuevo"
    guntilnew "anexar numero hasta nuevo"
    guntilnew_hlp "Probar todos los posibles valores del nmero hasta que se encuentre un nombre nuevo"
    ndigits "Nmero de dgitos"
    gennames "Generando nombres..."
    rentest_hlp "Probar mtodo actual con el nombre dado"
    renmove_hlp "Usar boton derecho para reordenar lneas"
    tolower "minsculas"
    toupper "maysculas"
    applyto "Aplicar a"
    forall "para todos"
    selfont "Seleccin de fuente"
    default "Habitual"
    size "Tamao"
    units "Unidades"
    points "puntos"
    pixels "pixels"
    weight "Peso"
    normal "normal"
    bold  "negrita"
    slant "Inclinada"
    roman "roman"
    italic "cursiva"
    underline "Subrayada"
    overstrike "Tachada"
    optDEFAULTFONT "Tipo de letra, por defecto"
    optFIXEDFONT "Tipo de letra, monoespaciada"
    optMAPFONT "Tipo de letra, mapa"
    optTRAVELFONT "Tipo de letra, viaje"
    optPLOTFONT "Tipo de letra, grficos"
    failed "fall"
    plugin  "Complemento"
    unavailif  "No disponible si"
    tclcode  "Cdigo Tcl"
    uname "Nombre de Usuario"
    pword "Clave de Acceso"
    remember "Recordar"
    wptotwitter "Punto a Twitter"
    wptotwitternb "Enviar posicin, datum, altitud, nombre y comentario del punto a Twitter con tags #GPSMan #waypoint"
    exportTFW "Exportar fichero TFW"
    nametfwfile "Fichero TFW"
    gpTRtoGnuplot2d "Perfil (Gnuplot)"
    gpTRtoGnuplot2d_nb "Mostrar grfico de altitud con los datos de trayecto usuando el programa externo GNUPLOT"
    gpTRtoGnuplot3d "Perspectiva (Gnuplot)"
    gpTRtoGnuplot3d_nb "Mostrar grfico 3D de altitud con los datos de trayecto usando el programa externo GNUPLOT"
    gpParam2d "Parmetros para grfico 2D de Gnuplot"
    gpParam3d "Parmetros para grfico 3D de Gnuplot"
    gpFilename "Fichero"
    gpCanwidth   "Ancho del dibujo"
    gpCanheight  "Altura del dibujo"
    gpSTotals  "Mostrar totales"
    gpLeft  "Lado izquierdo"
    gpRight "Lado derecho"
    gpNone  "Ninguno"
    gpSRests "Mostrar descansos"
    gpRest  "Descanso"
    gpSymText "Smbolo+Texto"
    gpSymTime "Smbolo+Tiempo"
    gpText  "Texto"
    gpSym   "Smbolo"
    gpSHours "Mostrar horas"
    gpTimetop "Tiempo arriba"
    gpTimebot "Tiempo abajo"
    gpSSpeed "Mostrar velocidad"
    gpHike  "A pie"
    gpBike  "Bicicleta"
    gpDrive "Coche"
    gpGlide "Volando"
    gpLimitDist "Distancia mxima del punto al trayecto (km)"
    gpLimitStat "Longitud mnima en el trayecto para el mismo punto (km)"
    gpDirection "Direccin"
    gpForward "Adelante"
    gpBackward "Atrs"
    gp2D_hlp "Si el nombre de grupo es igual al del trayecto,\n\
              los puntos de este grupo se mostrarn\n\
              dependiendo de las distancias dadas.\n\
              Cuando no exista un nombre de grupo,\n\
              se escogern los puntos de una lista o se cancela."
    gpGenerated "Generado con Gnuplot por GPSMan"
    gpModify "Modificar la vista con el ratn. Salga para guardar imagen."
    htCalcHikeTime "Calcular tiempo de recorrido"
    htCalcHikeTime_nb "Calcular tiempo de recorrido con la frmula de DAV"
    htHeader "Tiempo estimado de recorrido (sin descansos) con la frmula de \
              \"Deutscher Alpenverein\" con parmetros dados"
    htFooter1 "Capacidad en una hora."
    htFooter2 "El tiempo sugerido de descanso es 20min despus de 2 horas (15%)."
    srShowRest_nb "Mostrar descansos > 5min."
    srTRTime   "Tiempo de trayecto"
    srTotals   "Totales"
    optALTHRESHOLD "Lmite de altitud"
    optDISPLAYCMD "Comando para mostrar fichero de imagen"
    optTERMCMD "Comando para abrir ventana de terminal"
    optMANHTTPADDR "Direccin HTTP del manual de usuario"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    GMS   DMS
    GMM   DMM
    GGG   DDD
    Grados GRA
    UTM/UPS   UTM/UPS
    MH   MH
    PT   WP
    RT   RT
    TR   TR
    PL   LP
    LAP LAP
    GR   GR
}

# changes by Miguel Filgueiras to RM contribution
set TXT(srChainage) $TXT(totdst)
set TXT(srShowRest) $TXT(gpSRests)
set TXT(gpSym) $TXT(symbol)
set TXT(srRest) $TXT(gpRest)
