/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.compiler.ast.AstTransformer;
import grails.compiler.ast.ClassInjector;
import grails.compiler.ast.GlobalClassInjector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.PathMatchingResourcePatternResolver;
import org.grails.io.support.Resource;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.util.ClassUtils;

public class GrailsAwareInjectionOperation
extends CompilationUnit.PrimaryClassNodeOperation {
    private static final String INJECTOR_SCAN_PACKAGE = "org.grails.compiler";
    private static final String INJECTOR_CODEHAUS_SCAN_PACKAGE = "org.codehaus.groovy.grails.compiler";
    private static ClassInjector[] classInjectors;
    private static ClassInjector[] globalClassInjectors;
    private ClassInjector[] localClassInjectors;

    public GrailsAwareInjectionOperation() {
        GrailsAwareInjectionOperation.initializeState();
    }

    public GrailsAwareInjectionOperation(ClassInjector[] classInjectors) {
        this();
        this.localClassInjectors = classInjectors;
    }

    public static ClassInjector[] getClassInjectors() {
        if (classInjectors == null) {
            GrailsAwareInjectionOperation.initializeState();
        }
        return classInjectors;
    }

    public static ClassInjector[] getGlobalClassInjectors() {
        if (classInjectors == null) {
            GrailsAwareInjectionOperation.initializeState();
        }
        return globalClassInjectors;
    }

    public ClassInjector[] getLocalClassInjectors() {
        if (this.localClassInjectors == null) {
            return GrailsAwareInjectionOperation.getClassInjectors();
        }
        return this.localClassInjectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeState() {
        if (classInjectors != null) {
            return;
        }
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)INJECTOR_CODEHAUS_SCAN_PACKAGE) + "/**/*.class";
        String pattern2 = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)INJECTOR_SCAN_PACKAGE) + "/**/*.class";
        ClassLoader classLoader = GrailsAwareInjectionOperation.class.getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        try {
            Resource[] resources = GrailsAwareInjectionOperation.scanForPatterns(resolver, pattern2, pattern);
            if (resources.length == 0) {
                classLoader = Thread.currentThread().getContextClassLoader();
                resolver = new PathMatchingResourcePatternResolver(classLoader);
                resources = GrailsAwareInjectionOperation.scanForPatterns(resolver, pattern2, pattern);
            }
            final ArrayList injectors = new ArrayList();
            final ArrayList globalInjectors = new ArrayList();
            final HashSet injectorClasses = new HashSet();
            for (Resource resource : resources) {
                if (!resource.isReadable() || resource.getFilename().contains("$_")) continue;
                try (InputStream inputStream = resource.getInputStream();){
                    final ClassReader classReader = new ClassReader(inputStream);
                    final String astTransformerClassName = AstTransformer.class.getSimpleName();
                    final ClassLoader finalClassLoader = classLoader;
                    classReader.accept(new ClassVisitor(262144){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            try {
                                if (visible && desc.contains(astTransformerClassName)) {
                                    Class<?> injectorClass = finalClassLoader.loadClass(classReader.getClassName().replace('/', '.'));
                                    if (injectorClasses.contains(injectorClass)) {
                                        return super.visitAnnotation(desc, true);
                                    }
                                    if (ClassInjector.class.isAssignableFrom(injectorClass)) {
                                        injectorClasses.add(injectorClass);
                                        ClassInjector classInjector = (ClassInjector)injectorClass.newInstance();
                                        injectors.add(classInjector);
                                        if (GlobalClassInjector.class.isAssignableFrom(injectorClass)) {
                                            globalInjectors.add(classInjector);
                                        }
                                    }
                                }
                            }
                            catch (ClassNotFoundException e) {
                            }
                            catch (InstantiationException e) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                            return super.visitAnnotation(desc, visible);
                        }
                    }, 1);
                }
            }
            Collections.sort(injectors, new Comparator<ClassInjector>(){

                @Override
                public int compare(ClassInjector classInjectorA, ClassInjector classInjectorB) {
                    if (classInjectorA instanceof Comparable) {
                        return ((Comparable)((Object)classInjectorA)).compareTo(classInjectorB);
                    }
                    return 0;
                }
            });
            classInjectors = injectors.toArray(new ClassInjector[injectors.size()]);
            globalClassInjectors = globalInjectors.toArray(new ClassInjector[globalInjectors.size()]);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static Resource[] scanForPatterns(PathMatchingResourcePatternResolver resolver, String ... patterns) throws IOException {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (String pattern : patterns) {
            results.addAll(Arrays.asList(resolver.getResources(pattern)));
        }
        return results.toArray(new Resource[results.size()]);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        ClassInjector[] classInjectors1;
        URL url = null;
        String filename = source.getName();
        FileSystemResource resource = new FileSystemResource(filename);
        if (resource.exists()) {
            try {
                url = resource.getURL();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((classInjectors1 = this.getLocalClassInjectors()) == null || classInjectors1.length == 0) {
            classInjectors1 = GrailsAwareInjectionOperation.getClassInjectors();
        }
        for (ClassInjector classInjector : classInjectors1) {
            if (!classInjector.shouldInject(url)) continue;
            classInjector.performInjection(source, context, classNode);
        }
    }
}

