/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.Rule;
import org.w3c.css.sac.SACMediaList;

public class StyleSheet {
    protected Rule[] rules = new Rule[16];
    protected int size;
    protected StyleSheet parent;
    protected boolean alternate;
    protected SACMediaList media;
    protected String title;

    public void setMedia(SACMediaList sACMediaList) {
        this.media = sACMediaList;
    }

    public SACMediaList getMedia() {
        return this.media;
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public void setParent(StyleSheet styleSheet) {
        this.parent = styleSheet;
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Rule getRule(int n) {
        return this.rules[n];
    }

    public void clear() {
        this.size = 0;
        this.rules = new Rule[10];
    }

    public void append(Rule rule) {
        if (this.size == this.rules.length) {
            Rule[] ruleArray = new Rule[this.size * 2];
            System.arraycopy(this.rules, 0, ruleArray, 0, this.size);
            this.rules = ruleArray;
        }
        this.rules[this.size++] = rule;
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuffer stringBuffer = new StringBuffer(this.size * 8);
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.rules[i].toString(cSSEngine));
        }
        return stringBuffer.toString();
    }
}

