/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WayNodesConflictResolverCommand
extends ConflictResolveCommand {
    private final Conflict<Way> conflict;
    private final List<Node> mergedNodeList;

    public WayNodesConflictResolverCommand(Conflict<? extends OsmPrimitive> conflict, List<Node> list) {
        this.conflict = conflict;
        this.mergedNodeList = list;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in node list of way {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (Node node : this.mergedNodeList) {
            if (this.getAffectedDataSet().getNodes().contains(node)) continue;
            Main.warn(I18n.tr("Main dataset does not include node {0}", node.toString()));
        }
        this.conflict.getMy().setNodes(this.mergedNodeList);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict, this.mergedNodeList);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        WayNodesConflictResolverCommand wayNodesConflictResolverCommand = (WayNodesConflictResolverCommand)object;
        return Objects.equals(this.conflict, wayNodesConflictResolverCommand.conflict) && Objects.equals(this.mergedNodeList, wayNodesConflictResolverCommand.mergedNodeList);
    }
}

