/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractPrimitive
implements IPrimitive {
    private static final AtomicLong idCounter = new AtomicLong(0L);
    protected static final short FLAG_MODIFIED = 1;
    protected static final short FLAG_VISIBLE = 2;
    protected static final short FLAG_DELETED = 4;
    protected static final short FLAG_INCOMPLETE = 8;
    protected static final short FLAG_DISABLED = 16;
    protected static final short FLAG_HIDE_IF_DISABLED = 32;
    protected static final short FLAG_DISABLED_TYPE = 64;
    protected static final short FLAG_HIDDEN_TYPE = 128;
    protected static final short FLAG_HAS_DIRECTIONS = 256;
    protected static final short FLAG_TAGGED = 512;
    protected static final short FLAG_DIRECTION_REVERSED = 1024;
    protected static final short FLAG_HIGHLIGHTED = 2048;
    protected static final short FLAG_ANNOTATED = 4096;
    protected volatile short flags = (short)2;
    protected long id;
    protected User user;
    protected int version;
    protected int changesetId;
    protected int timestamp;
    protected volatile String[] keys;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public void cloneFrom(AbstractPrimitive abstractPrimitive) {
        this.setKeys(abstractPrimitive.getKeys());
        this.id = abstractPrimitive.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = abstractPrimitive.timestamp;
        if (this.id > 0L) {
            this.version = abstractPrimitive.version;
        }
        this.flags = abstractPrimitive.flags;
        this.user = abstractPrimitive.user;
        if (this.id > 0L && abstractPrimitive.changesetId > 0) {
            this.setChangesetId(abstractPrimitive.changesetId);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getId() {
        long l = this.id;
        return l >= 0L ? l : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    @Override
    public boolean isNewOrUndeleted() {
        return this.isNew() || (this.flags & 6) == 0;
    }

    @Override
    public void setOsmId(long l, int n) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
        }
        this.id = l;
        this.version = n;
        this.setIncomplete(false);
    }

    public void clearOsmMetadata() {
        this.id = AbstractPrimitive.generateUniqueId();
        this.version = 0;
        this.user = null;
        this.changesetId = 0;
        this.timestamp = 0;
        this.setIncomplete(false);
        this.setDeleted(false);
        this.setVisible(true);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int getChangesetId() {
        return this.changesetId;
    }

    @Override
    public void setChangesetId(int n) {
        if (this.changesetId == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", n));
        }
        if (this.isNew() && n > 0) {
            throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", n));
        }
        this.changesetId = n;
    }

    @Override
    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    public OsmPrimitiveType getDisplayType() {
        return this.getType();
    }

    @Override
    public void setTimestamp(Date date) {
        this.timestamp = (int)TimeUnit.MILLISECONDS.toSeconds(date.getTime());
    }

    @Override
    public void setRawTimestamp(int n) {
        this.timestamp = n;
    }

    @Override
    public Date getTimestamp() {
        return new Date(TimeUnit.SECONDS.toMillis(this.timestamp));
    }

    @Override
    public int getRawTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    protected void updateFlags(short s, boolean bl) {
        this.flags = bl ? (short)(this.flags | s) : (short)(this.flags & (short)(~s));
    }

    @Override
    public void setModified(boolean bl) {
        this.updateFlags((short)1, bl);
    }

    @Override
    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isUndeleted() {
        return (this.flags & 6) == 0;
    }

    @Override
    public boolean isUsable() {
        return (this.flags & 0xC) == 0;
    }

    @Override
    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.isNew() && !bl) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible.", new Object[0]));
        }
        this.updateFlags((short)2, bl);
    }

    @Override
    public void setDeleted(boolean bl) {
        this.updateFlags((short)4, bl);
        this.setModified(bl ^ !this.isVisible());
    }

    protected void setIncomplete(boolean bl) {
        this.updateFlags((short)8, bl);
    }

    @Override
    public boolean isIncomplete() {
        return (this.flags & 8) != 0;
    }

    protected String getFlagsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isIncomplete()) {
            stringBuilder.append('I');
        }
        if (this.isModified()) {
            stringBuilder.append('M');
        }
        if (this.isVisible()) {
            stringBuilder.append('V');
        }
        if (this.isDeleted()) {
            stringBuilder.append('D');
        }
        return stringBuilder.toString();
    }

    public TagMap getKeys() {
        return new TagMap(this.keys);
    }

    public void visitKeys(KeyValueVisitor keyValueVisitor) {
        String[] stringArray = this.keys;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                keyValueVisitor.visitKeyValue(this, stringArray[i], stringArray[i + 1]);
            }
        }
    }

    @Override
    public void setKeys(Map<String, String> map) {
        TagMap tagMap = this.getKeys();
        if (map == null || map.isEmpty()) {
            this.keys = null;
            this.keysChangedImpl(tagMap);
            return;
        }
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue();
        }
        this.keys = stringArray;
        this.keysChangedImpl(tagMap);
    }

    public void setKeys(TagMap tagMap) {
        String[] stringArray;
        TagMap tagMap2 = this.getKeys();
        this.keys = tagMap == null ? null : ((stringArray = tagMap.getTagsArray()).length == 0 ? null : stringArray);
        this.keysChangedImpl(tagMap2);
    }

    @Override
    public void put(String string, String string2) {
        TagMap tagMap = this.getKeys();
        if (string == null || Utils.strip(string).isEmpty()) {
            return;
        }
        if (string2 == null) {
            this.remove(string);
        } else if (this.keys == null) {
            this.keys = new String[]{string, string2};
            this.keysChangedImpl(tagMap);
        } else {
            int n = AbstractPrimitive.indexOfKey(this.keys, string);
            int n2 = this.keys.length;
            if (n < 0) {
                n = n2;
                n2 += 2;
            }
            String[] stringArray = Arrays.copyOf(this.keys, n2);
            stringArray[n] = string;
            stringArray[n + 1] = string2;
            this.keys = stringArray;
            this.keysChangedImpl(tagMap);
        }
    }

    private static int indexOfKey(String[] stringArray, String string) {
        if (stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove(String string) {
        if (string == null || this.keys == null) {
            return;
        }
        if (!this.hasKey(string)) {
            return;
        }
        TagMap tagMap = this.getKeys();
        if (this.keys.length == 2) {
            this.keys = null;
            this.keysChangedImpl(tagMap);
            return;
        }
        String[] stringArray = new String[this.keys.length - 2];
        int n = 0;
        for (int i = 0; i < this.keys.length; i += 2) {
            if (this.keys[i].equals(string)) continue;
            stringArray[n++] = this.keys[i];
            stringArray[n++] = this.keys[i + 1];
        }
        this.keys = stringArray;
        this.keysChangedImpl(tagMap);
    }

    @Override
    public void removeAll() {
        if (this.keys != null) {
            TagMap tagMap = this.getKeys();
            this.keys = null;
            this.keysChangedImpl(tagMap);
        }
    }

    @Override
    public final String get(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public final boolean isKeyTrue(String string) {
        return OsmUtils.isTrue(this.get(string));
    }

    public final boolean isKeyFalse(String string) {
        return OsmUtils.isFalse(this.get(string));
    }

    public final String getIgnoreCase(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public final int getNumKeys() {
        String[] stringArray = this.keys;
        return stringArray == null ? 0 : stringArray.length / 2;
    }

    @Override
    public final Collection<String> keySet() {
        String[] stringArray = this.keys;
        if (stringArray == null) {
            return Collections.emptySet();
        }
        if (stringArray.length == 1) {
            return Collections.singleton(stringArray[0]);
        }
        HashSet<String> hashSet = new HashSet<String>(Utils.hashMapInitialCapacity(stringArray.length / 2));
        for (int i = 0; i < stringArray.length; i += 2) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    public boolean hasKey(String string) {
        return string != null && AbstractPrimitive.indexOfKey(this.keys, string) >= 0;
    }

    protected abstract void keysChangedImpl(Map<String, String> var1);

    @Override
    public String getName() {
        return this.get("name");
    }

    @Override
    public String getLocalName() {
        for (String string : LanguageInfo.getLanguageCodes(null)) {
            String string2 = this.get("name:" + string);
            if (string2 == null) continue;
            return string2;
        }
        return this.getName();
    }

    public boolean hasTag(String string, String string2) {
        return Objects.equals(string2, this.get(string));
    }

    public boolean hasTag(String string, String ... stringArray) {
        return this.hasTag(string, Arrays.asList(stringArray));
    }

    public boolean hasTag(String string, Collection<String> collection) {
        return collection.contains(this.get(string));
    }

    @FunctionalInterface
    public static interface KeyValueVisitor {
        public void visitKeyValue(AbstractPrimitive var1, String var2, String var3);
    }
}

