/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;

public abstract class AbstractProperty<T> {
    protected final Preferences preferences = Main.pref;
    protected final String key;
    protected final T defaultValue;

    public AbstractProperty(String string, T t) {
        this.key = string;
        this.defaultValue = t;
    }

    protected void storeDefaultValue() {
        if (this.getPreferences() != null) {
            this.get();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSet() {
        return !this.getPreferences().get(this.key).isEmpty();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void remove() {
        this.put(this.getDefaultValue());
    }

    public abstract T get();

    public abstract boolean put(T var1);

    protected Preferences getPreferences() {
        return this.preferences;
    }

    public void addListener(ValueChangeListener<? super T> valueChangeListener) {
        this.addListenerImpl(new PreferenceChangedListenerAdapter(valueChangeListener));
    }

    protected void addListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
        this.getPreferences().addKeyPreferenceChangeListener(this.getKey(), preferenceChangedListener);
    }

    public void addWeakListener(ValueChangeListener<? super T> valueChangeListener) {
        this.addWeakListenerImpl(new PreferenceChangedListenerAdapter(valueChangeListener));
    }

    protected void addWeakListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
        this.getPreferences().addWeakKeyPreferenceChangeListener(this.getKey(), preferenceChangedListener);
    }

    public void removeListener(ValueChangeListener<? super T> valueChangeListener) {
        this.removeListenerImpl(new PreferenceChangedListenerAdapter(valueChangeListener));
    }

    protected void removeListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
        this.getPreferences().removeKeyPreferenceChangeListener(this.getKey(), preferenceChangedListener);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        n = 31 * n + (this.preferences == null ? 0 : this.preferences.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractProperty abstractProperty = (AbstractProperty)object;
        if (this.key == null ? abstractProperty.key != null : !this.key.equals(abstractProperty.key)) {
            return false;
        }
        return !(this.preferences == null ? abstractProperty.preferences != null : !this.preferences.equals(abstractProperty.preferences));
    }

    public static class InvalidPreferenceValueException
    extends RuntimeException {
        public InvalidPreferenceValueException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InvalidPreferenceValueException(String string) {
            super(string);
        }

        public InvalidPreferenceValueException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ValueChangeEvent<T> {
        private final Preferences.PreferenceChangeEvent base;
        private final AbstractProperty<T> source;

        ValueChangeEvent(Preferences.PreferenceChangeEvent preferenceChangeEvent, AbstractProperty<T> abstractProperty) {
            this.base = preferenceChangeEvent;
            this.source = abstractProperty;
        }

        public AbstractProperty<T> getProperty() {
            return this.source;
        }
    }

    @FunctionalInterface
    public static interface ValueChangeListener<T> {
        public void valueChanged(ValueChangeEvent<? extends T> var1);
    }

    private final class PreferenceChangedListenerAdapter
    implements Preferences.PreferenceChangedListener {
        private final ValueChangeListener<? super T> listener;

        PreferenceChangedListenerAdapter(ValueChangeListener<? super T> valueChangeListener) {
            this.listener = valueChangeListener;
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            this.listener.valueChanged(new ValueChangeEvent(preferenceChangeEvent, AbstractProperty.this));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.listener == null ? 0 : this.listener.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PreferenceChangedListenerAdapter preferenceChangedListenerAdapter = (PreferenceChangedListenerAdapter)object;
            if (!this.getOuterType().equals(preferenceChangedListenerAdapter.getOuterType())) {
                return false;
            }
            return !(this.listener == null ? preferenceChangedListenerAdapter.listener != null : !this.listener.equals(preferenceChangedListenerAdapter.listener));
        }

        private AbstractProperty<T> getOuterType() {
            return AbstractProperty.this;
        }

        public String toString() {
            return "PreferenceChangedListenerAdapter [listener=" + this.listener + ']';
        }
    }
}

