/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

public class ExactMath {
    @Deprecated
    public ExactMath() {
    }

    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("long overflow");
        }
        return (int)r;
    }

    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int multiplyHigh(int x, int y) {
        long r = (long)x * (long)y;
        return (int)(r >> 32);
    }

    public static int multiplyHighUnsigned(int x, int y) {
        long xl = (long)x & 0xFFFFFFFFL;
        long yl = (long)y & 0xFFFFFFFFL;
        long r = xl * yl;
        return (int)(r >> 32);
    }

    public static long multiplyHigh(long x, long y) {
        long x0 = x & 0xFFFFFFFFL;
        long x1 = x >> 32;
        long y0 = y & 0xFFFFFFFFL;
        long y1 = y >> 32;
        long z0 = x0 * y0;
        long t = x1 * y0 + (z0 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z2 = t >> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >> 32);
    }

    public static long multiplyHighUnsigned(long x, long y) {
        long x0 = x & 0xFFFFFFFFL;
        long x1 = x >>> 32;
        long y0 = y & 0xFFFFFFFFL;
        long y1 = y >>> 32;
        long z0 = x0 * y0;
        long t = x1 * y0 + (z0 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z2 = t >>> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >>> 32);
    }
}

