/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;

final class ForeignAccessArguments
extends Node {
    static final Object[] EMPTY_ARGUMENTS_ARRAY = new Object[0];
    static final int RECEIVER_INDEX = 0;
    static final int RUNTIME_ARGUMENT_COUNT = 1;
    @CompilerDirectives.CompilationFinal
    private int previousLength = -2;

    ForeignAccessArguments() {
    }

    public Object[] executeCreate(Object receiver, Object ... arguments) {
        int length = this.profileLength(arguments.length);
        Object[] objectArguments = new Object[1 + length];
        objectArguments[0] = receiver;
        ForeignAccessArguments.arraycopy(arguments, 0, objectArguments, 1, length);
        return objectArguments;
    }

    private int profileLength(int length) {
        int returnLength = length;
        if (this.previousLength != -1) {
            if (this.previousLength == length) {
                returnLength = this.previousLength;
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.previousLength = this.previousLength == -2 ? length : -1;
            }
        }
        return returnLength;
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = src[srcPos + i];
        }
    }
}

