/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class HashNode
extends RubyBaseNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    private final ConditionProfile isIntegerProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isLongProfile = ConditionProfile.createBinaryProfile();

    public HashNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context, true);
    }

    public int hash(VirtualFrame frame, Object key) {
        Object hashedObject = this.hashNode.call(frame, key, "hash", new Object[0]);
        if (this.isIntegerProfile.profile(hashedObject instanceof Integer)) {
            return (Integer)hashedObject;
        }
        if (this.isLongProfile.profile(hashedObject instanceof Long)) {
            return (int)((Long)hashedObject).longValue();
        }
        throw new UnsupportedOperationException();
    }
}

