/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.types;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.Arrays;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.annotation.processing.impl.DisposableRef;
import org.jetbrains.kotlin.annotation.processing.impl.DisposableRefKt;
import org.jetbrains.kotlin.java.model.JeConverterKt;
import org.jetbrains.kotlin.java.model.elements.JeTypeParameterElement;
import org.jetbrains.kotlin.java.model.types.JeNullType;
import org.jetbrains.kotlin.java.model.types.JePsiTypeBase;
import org.jetbrains.kotlin.java.model.types.JeTypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J=\u0010\u0010\u001a\n \u0012*\u0004\u0018\u0001H\u0011H\u0011\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010#H\u0016J\b\u0010%\u001a\u00020&H\u0016J\r\u0010'\u001a\u00070(\u00a2\u0006\u0002\b)H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/java/model/types/JeTypeVariableType;", "Lorg/jetbrains/kotlin/java/model/types/JePsiTypeBase;", "Lcom/intellij/psi/PsiClassType;", "Ljavax/lang/model/type/TypeVariable;", "psiType", "parameter", "Lcom/intellij/psi/PsiTypeParameter;", "(Lcom/intellij/psi/PsiClassType;Lcom/intellij/psi/PsiTypeParameter;)V", "disposableParameter", "Lorg/jetbrains/kotlin/annotation/processing/impl/DisposableRef;", "getParameter", "()Lcom/intellij/psi/PsiTypeParameter;", "psiManager", "Lcom/intellij/psi/PsiManager;", "getPsiManager", "()Lcom/intellij/psi/PsiManager;", "accept", "R", "kotlin.jvm.PlatformType", "P", "v", "Ljavax/lang/model/type/TypeVisitor;", "p", "(Ljavax/lang/model/type/TypeVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "asElement", "Lorg/jetbrains/kotlin/java/model/elements/JeTypeParameterElement;", "dispose", "", "equals", "", "other", "", "getKind", "Ljavax/lang/model/type/TypeKind;", "getLowerBound", "Ljavax/lang/model/type/TypeMirror;", "getUpperBound", "hashCode", "", "toString", "", "Lorg/jetbrains/annotations/Nullable;", "annotation-processing"})
public final class JeTypeVariableType
extends JePsiTypeBase<PsiClassType>
implements TypeVariable {
    private final DisposableRef<PsiTypeParameter> disposableParameter;

    @NotNull
    public final PsiTypeParameter getParameter() {
        return this.disposableParameter.invoke();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposableParameter.dispose();
    }

    @Override
    @NotNull
    public TypeKind getKind() {
        return TypeKind.TYPEVAR;
    }

    @Override
    public <R, P> R accept(@NotNull TypeVisitor<R, P> v, P p) {
        Intrinsics.checkParameterIsNotNull(v, (String)"v");
        return v.visitTypeVariable(this, p);
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.getParameter().getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"parameter.manager");
        return psiManager;
    }

    @Override
    @Nullable
    public TypeMirror getLowerBound() {
        return JeNullType.INSTANCE;
    }

    @Override
    @Nullable
    public TypeMirror getUpperBound() {
        TypeMirror typeMirror;
        PsiClassType[] superTypes = this.getParameter().getSuperTypes();
        if (((Object[])superTypes).length == 1) {
            typeMirror = JeTypeUtils.toJeType$default((PsiType)ArraysKt.first((Object[])superTypes), this.getPsiManager(), false, 2, null);
        } else {
            PsiType[] psiTypeArray = (PsiType[])superTypes;
            typeMirror = JeTypeUtils.toJeType$default(PsiIntersectionType.createIntersection((PsiType[])Arrays.copyOf(psiTypeArray, psiTypeArray.length)), this.getPsiManager(), false, 2, null);
        }
        return typeMirror;
    }

    @Override
    @NotNull
    public JeTypeParameterElement asElement() {
        return new JeTypeParameterElement(this.getParameter(), JeConverterKt.toJeElement((PsiElement)this.getParameter().getOwner()));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        PsiClassType psiClassType = (PsiClassType)this.getPsiType();
        Object object2 = other;
        if (!(object2 instanceof JeTypeVariableType)) {
            object2 = null;
        }
        JeTypeVariableType jeTypeVariableType = (JeTypeVariableType)object2;
        return Intrinsics.areEqual((Object)psiClassType, (Object)(jeTypeVariableType != null ? (PsiClassType)jeTypeVariableType.getPsiType() : null));
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getParameter().getName();
        if (string == null) {
            string = "<none>";
        }
        return string;
    }

    @Override
    public int hashCode() {
        return ((PsiClassType)this.getPsiType()).hashCode();
    }

    public JeTypeVariableType(@NotNull PsiClassType psiType, @NotNull PsiTypeParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)psiType, (String)"psiType");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiType psiType2 = (PsiType)psiType;
        PsiManager psiManager = parameter.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"parameter.manager");
        super(psiType2, psiManager);
        this.disposableParameter = DisposableRefKt.toDisposable(parameter);
    }
}

