/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.CharNormalizer;
import org.jetbrains.annotations.Nullable;

public class NGram {
    public static final int N_GRAM = 3;
    private StringBuilder grams_ = new StringBuilder(" ");
    private boolean capitalword_ = false;

    public void addChar(char ch) {
        ch = CharNormalizer.normalize(ch);
        char lastChar = this.grams_.charAt(this.grams_.length() - 1);
        if (lastChar == ' ') {
            this.grams_ = new StringBuilder(" ");
            this.capitalword_ = false;
            if (ch == ' ') {
                return;
            }
        } else if (this.grams_.length() >= 3) {
            this.grams_.deleteCharAt(0);
        }
        this.grams_.append(ch);
        if (Character.isUpperCase(ch)) {
            if (Character.isUpperCase(lastChar)) {
                this.capitalword_ = true;
            }
        } else {
            this.capitalword_ = false;
        }
    }

    @Nullable
    public String get(int n) {
        if (this.capitalword_) {
            return null;
        }
        int len = this.grams_.length();
        if (n < 1 || n > 3 || len < n) {
            return null;
        }
        if (n == 1) {
            char ch = this.grams_.charAt(len - 1);
            if (ch == ' ') {
                return null;
            }
            return Character.toString(ch);
        }
        return this.grams_.substring(len - n, len);
    }
}

