/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.activity;

import com.baselet.control.enums.Direction;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.old.activity.Column;
import com.baselet.element.old.activity.Element;
import com.baselet.element.old.activity.EndIf;
import com.baselet.element.old.activity.If;
import com.baselet.element.old.activity.Row;
import com.baselet.element.old.activity.StartElement;
import com.baselet.element.old.activity.StopElement;
import com.baselet.element.old.activity.While;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class Container
extends Element {
    private final ArrayList<Column> columns = new ArrayList();
    private StartElement start;
    private StopElement stop;
    private final Container parent;
    private final ArrayList<Row> rows;
    private int max_row;
    private int current_row;
    private int init_row;
    private final AtomicBoolean autoInsertIF;

    public Container(AtomicBoolean autoInsertIF, DiagramHandler handler, Graphics2D g, Container parent, ArrayList<Row> rows, int row) {
        super(handler, g, 0, null);
        this.columns.add(new Column(g));
        this.rows = rows;
        this.init_row = row;
        this.max_row = row;
        this.current_row = row;
        this.parent = parent;
        this.autoInsertIF = autoInsertIF;
        if (autoInsertIF.get() && this.parent != null) {
            this.setStartElement(new If(handler, g, null));
        } else if (this.parent != null) {
            this.setStartElement(new StartElement(handler, g, 0, null));
        }
    }

    public Container addNewContainer() {
        Container c = new Container(this.autoInsertIF, this.getHandler(), this.getGraphics(), this, this.rows, this.current_row);
        this.columns.get(this.columns.size() - 1).addElement(c);
        return c;
    }

    public Container addNewWhile(String condition) {
        While c = new While(this.autoInsertIF, this.getHandler(), this.getGraphics(), this, this.rows, this.current_row, condition);
        this.columns.get(this.columns.size() - 1).addElement(c);
        return c;
    }

    protected ArrayList<Column> getColumns() {
        return this.columns;
    }

    protected Column getLastColumn() {
        return this.columns.get(this.columns.size() - 1);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Container close() {
        if (this.autoInsertIF.get() && this.parent != null) {
            this.setStopElement(new EndIf(this.getHandler(), this.getGraphics(), null));
        } else if (this.parent != null) {
            this.setStopElement(new StopElement(this.getHandler(), this.getGraphics(), 0, null));
        }
        return this.parent;
    }

    private Row getNextRow() {
        while (this.rows.size() <= this.current_row) {
            this.rows.add(new Row());
        }
        return this.rows.get(this.current_row);
    }

    private Row getFirstRow() {
        int init_row = this.init_row;
        if (this.start != null) {
            --init_row;
        }
        while (this.rows.size() <= init_row) {
            this.rows.add(new Row());
        }
        return this.rows.get(init_row);
    }

    private Row getLastRow() {
        int max_row = this.max_row;
        if (this.stop != null) {
            --max_row;
        }
        while (this.rows.size() <= max_row) {
            this.rows.add(new Row());
        }
        return this.rows.get(max_row);
    }

    private void inc_row() {
        ++this.current_row;
        if (this.current_row > this.max_row) {
            ++this.max_row;
            if (this.parent != null) {
                this.parent.inc_row();
            }
        }
    }

    public void setStartElement(StartElement e) {
        this.getFirstRow().exchangeElementOrInsert(this.start, e);
        if (this.start == null) {
            ++this.current_row;
            ++this.init_row;
            ++this.max_row;
            if (this.parent != null) {
                this.parent.inc_row();
            }
        }
        this.start = e;
    }

    public void setStopElement(StopElement e) {
        this.getLastRow().exchangeElementOrInsert(this.stop, e);
        if (this.stop == null) {
            ++this.max_row;
            if (this.parent != null) {
                this.parent.inc_row();
            }
        }
        this.stop = e;
    }

    public void addColumn() {
        this.columns.add(new Column(this.getGraphics()));
        this.current_row = this.init_row;
    }

    public void addElement(Element e) {
        this.columns.get(this.columns.size() - 1).addElement(e);
        this.getNextRow().addElement(e);
        this.inc_row();
    }

    @Override
    public boolean arrowIn() {
        if (this.start == null) {
            return false;
        }
        return this.start.arrowIn();
    }

    @Override
    public boolean connectIn() {
        for (Column c : this.columns) {
            if (!c.getFirstElement().connectIn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean connectOut_overrideable() {
        for (Column c : this.columns) {
            if (!c.getLastElement().connectOut()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Point getConnect(Direction dir) {
        if (dir.equals((Object)Direction.UP) && this.start != null) {
            return this.start.getConnect(dir);
        }
        if (dir.equals((Object)Direction.DOWN) && this.stop != null) {
            return this.stop.getConnect(dir);
        }
        return super.getConnect(dir);
    }

    @Override
    protected int getHeight() {
        int height = 0;
        for (Column c : this.columns) {
            int h = c.getHeight();
            if (h <= height) continue;
            height = h;
        }
        if (this.start != null) {
            height += this.start.getHeight();
        }
        if (this.stop != null) {
            height += this.stop.getHeight();
        }
        return height;
    }

    @Override
    public int getLeftWidth() {
        int width = 0;
        int i = 0;
        for (i = 0; i < this.columns.size() / 2; ++i) {
            width += this.columns.get(i).getWidth();
        }
        if (this.columns.size() % 2 == 1) {
            width += this.columns.get(i).getLeftWidth();
        }
        width = (int)((double)width + (double)(this.columns.size() - 1) / 2.0 * (double)(30.0f * this.getZoom()));
        if (this.start != null && this.start.getLeftWidth() > width) {
            width = this.start.getLeftWidth();
        }
        if (this.stop != null && this.stop.getLeftWidth() > width) {
            width = this.stop.getLeftWidth();
        }
        return width;
    }

    @Override
    protected int getRightWidth() {
        int width = 0;
        int i = this.columns.size() / 2;
        if (this.columns.size() % 2 == 1) {
            width += this.columns.get(i).getRightWidth();
            ++i;
        }
        while (i < this.columns.size()) {
            width += this.columns.get(i).getWidth();
            ++i;
        }
        width = (int)((double)width + (double)(this.columns.size() - 1) / 2.0 * (double)(30.0f * this.getZoom()));
        if (this.start != null && this.start.getRightWidth() > width) {
            width = this.start.getRightWidth();
        }
        if (this.stop != null && this.stop.getRightWidth() > width) {
            width = this.stop.getRightWidth();
        }
        return width;
    }

    @Override
    public int getWidth() {
        int width = 0;
        int i = 0;
        for (i = 0; i < this.columns.size(); ++i) {
            width += this.columns.get(i).getWidth();
        }
        width = (int)((float)width + (float)(this.columns.size() - 1) * (30.0f * this.getZoom()));
        if (this.start != null && this.start.getWidth() > width) {
            width = this.start.getWidth();
        }
        if (this.stop != null && this.stop.getWidth() > width) {
            width = this.stop.getWidth();
        }
        return width;
    }

    @Override
    public void setX(int x) {
        if (this.start != null) {
            this.start.setX(x);
        }
        if (this.stop != null) {
            this.stop.setX(x);
        }
        if (this.columns.size() == 1) {
            this.columns.get(0).setX(x);
        } else {
            x -= this.getLeftWidth();
            int i = 1;
            for (Column c : this.columns) {
                c.setX(x += c.getLeftWidth());
                x += c.getRightWidth();
                if (i < this.columns.size()) {
                    x = (int)((float)x + 30.0f * this.getZoom());
                }
                ++i;
            }
        }
    }

    protected StartElement getStartElement() {
        return this.start;
    }

    protected StopElement getStopElement() {
        return this.stop;
    }

    public void removeEmptyColumns() {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).isEmpty()) {
                this.columns.remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void paint() {
        boolean paintstart = this.connectIn();
        boolean paintstop = this.connectOut();
        if (this.start == null) {
            paintstart = false;
        }
        if (this.stop == null) {
            paintstop = false;
        }
        if (paintstart) {
            this.start.paint();
        }
        if (paintstop) {
            this.stop.paint();
        }
        for (Column c : this.columns) {
            if (paintstart) {
                this.start.connectTo(c.getFirstElement());
            }
            c.paint();
            if (!paintstop) continue;
            this.stop.connectTo(c.getLastElement());
        }
    }

    @Override
    public void printData(String prefix) {
        prefix = prefix + "    ";
        for (Column c : this.columns) {
            c.printData(prefix + "\n");
        }
    }
}

