/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

public class NestedTableColumnHeader
extends TableColumnHeader {
    private final ListChangeListener<TableColumn> columnsListener = new ListChangeListener<TableColumn>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn> change) {
            NestedTableColumnHeader.this.updateTableColumnHeaders();
        }
    };
    private final InvalidationListener columnTextListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            NestedTableColumnHeader.this.label.setVisible(NestedTableColumnHeader.this.getTableColumn().getText() != null && !NestedTableColumnHeader.this.getTableColumn().getText().isEmpty());
        }
    };
    private final InvalidationListener resizePolicyListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            NestedTableColumnHeader.this.updateContent();
        }
    };
    private final WeakListChangeListener weakColumnsListener = new WeakListChangeListener<TableColumn>(this.columnsListener);
    private final WeakInvalidationListener weakColumnTextListener = new WeakInvalidationListener(this.columnTextListener);
    private final WeakInvalidationListener weakResizePolicyListener = new WeakInvalidationListener(this.resizePolicyListener);
    private static final int DRAG_RECT_WIDTH = 4;
    private ObservableList<? extends TableColumn> columns;
    private TableColumnHeader label;
    private ObservableList<TableColumnHeader> columnHeaders;
    private static final String TABLE_COLUMN_KEY = "TableColumn";
    private static final String TABLE_COLUMN_HEADER_KEY = "TableColumnHeader";
    private static final EventHandler<MouseEvent> rectMousePressed = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            TableColumn tableColumn = (TableColumn)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!nestedTableColumnHeader.isColumnResizingEnabled()) {
                return;
            }
            if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
                nestedTableColumnHeader.resizeToFit(tableColumn, -1);
            } else {
                Rectangle rectangle2 = (Rectangle)mouseEvent.getSource();
                double d = nestedTableColumnHeader.getTableHeaderRow().sceneToLocal(rectangle2.localToScene(rectangle2.getBoundsInLocal())).getMinX() + 2.0;
                nestedTableColumnHeader.dragAnchorX = mouseEvent.getSceneX();
                nestedTableColumnHeader.columnResizingStarted(d);
            }
            mouseEvent.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectMouseDragged = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            TableColumn tableColumn = (TableColumn)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!nestedTableColumnHeader.isColumnResizingEnabled()) {
                return;
            }
            nestedTableColumnHeader.columnResizing(tableColumn, mouseEvent);
            mouseEvent.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectMouseReleased = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            TableColumn tableColumn = (TableColumn)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!nestedTableColumnHeader.isColumnResizingEnabled()) {
                return;
            }
            nestedTableColumnHeader.columnResizingComplete(tableColumn, mouseEvent);
            mouseEvent.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectCursorChangeListener = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            TableColumn tableColumn = (TableColumn)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)rectangle.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            rectangle.setCursor(nestedTableColumnHeader.isColumnResizingEnabled() && rectangle.isHover() && tableColumn.isResizable() ? Cursor.H_RESIZE : Cursor.DEFAULT);
        }
    };
    private double lastX = 0.0;
    private double dragAnchorX = 0.0;
    private List<Rectangle> dragRects = new ArrayList<Rectangle>();

    NestedTableColumnHeader(TableView tableView, TableColumn tableColumn) {
        super(tableView, tableColumn);
        this.getStyleClass().setAll((String[])new String[]{"nested-column-header"});
        this.setFocusTraversable(false);
        this.initUI();
        this.updateTableColumnHeaders();
    }

    @Override
    public void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        super.setTableHeaderRow(tableHeaderRow);
        this.label.setTableHeaderRow(tableHeaderRow);
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            tableColumnHeader.setTableHeaderRow(tableHeaderRow);
        }
    }

    @Override
    public void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        super.setParentHeader(nestedTableColumnHeader);
        this.label.setParentHeader(nestedTableColumnHeader);
    }

    ObservableList<? extends TableColumn> getColumns() {
        return this.columns;
    }

    void setColumns(ObservableList<? extends TableColumn> observableList) {
        if (this.columns != null) {
            this.columns.removeListener(this.weakColumnsListener);
        }
        this.columns = observableList;
        if (this.columns != null) {
            this.columns.addListener(this.weakColumnsListener);
        }
    }

    void updateTableColumnHeaders() {
        TableColumnHeader tableColumnHeader;
        if (this.getTableColumn() == null && this.getTableView() != null) {
            this.setColumns(this.getTableView().getColumns());
        } else if (this.getTableColumn() != null) {
            this.setColumns(this.getTableColumn().getColumns());
        }
        for (int i = 0; i < this.getColumnHeaders().size(); ++i) {
            tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(i);
            tableColumnHeader.dispose();
        }
        if (this.getColumns().isEmpty()) {
            NestedTableColumnHeader nestedTableColumnHeader = this.getParentHeader();
            if (nestedTableColumnHeader != null) {
                tableColumnHeader = this.createColumnHeader(this.getTableColumn());
                ObservableList<TableColumnHeader> observableList = nestedTableColumnHeader.getColumnHeaders();
                int n = observableList.indexOf(this);
                if (n >= 0 && n < observableList.size()) {
                    observableList.set(n, tableColumnHeader);
                }
            }
        } else {
            ArrayList<TableColumnHeader> arrayList = new ArrayList<TableColumnHeader>();
            for (int i = 0; i < this.getColumns().size(); ++i) {
                TableColumn tableColumn = (TableColumn)this.getColumns().get(i);
                if (tableColumn == null) continue;
                TableColumnHeader tableColumnHeader2 = this.createColumnHeader(tableColumn);
                arrayList.add(tableColumnHeader2);
            }
            this.getColumnHeaders().setAll((Collection<TableColumnHeader>)arrayList);
        }
        this.updateContent();
    }

    @Override
    void dispose() {
        Node node;
        int n;
        super.dispose();
        if (this.label != null) {
            this.label.dispose();
        }
        this.getColumns().removeListener(this.weakColumnsListener);
        this.getTableColumn().textProperty().removeListener(this.weakColumnTextListener);
        this.getTableView().columnResizePolicyProperty().removeListener(this.weakResizePolicyListener);
        for (n = 0; n < this.getColumnHeaders().size(); ++n) {
            node = (TableColumnHeader)this.getColumnHeaders().get(n);
            ((TableColumnHeader)node).dispose();
        }
        for (n = 0; n < this.dragRects.size(); ++n) {
            node = this.dragRects.get(n);
            node.visibleProperty().unbind();
        }
        this.dragRects.clear();
        this.getChildren().clear();
    }

    public ObservableList<TableColumnHeader> getColumnHeaders() {
        if (this.columnHeaders == null) {
            this.columnHeaders = FXCollections.observableArrayList();
        }
        return this.columnHeaders;
    }

    private void initUI() {
        this.label = new TableColumnHeader(this.getTableView(), this.getTableColumn());
        this.label.setTableHeaderRow(this.getTableHeaderRow());
        this.label.setParentHeader(this.getParentHeader());
        this.label.setNestedColumnHeader(this);
        if (this.getTableColumn() != null) {
            this.getTableColumn().textProperty().addListener(this.weakColumnTextListener);
        }
        this.getTableView().columnResizePolicyProperty().addListener(this.weakResizePolicyListener);
        this.updateContent();
    }

    private void updateContent() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(this.label);
        arrayList.addAll(this.getColumnHeaders());
        if (this.isColumnResizingEnabled()) {
            this.rebuildDragRects();
            arrayList.addAll(this.dragRects);
        }
        this.getChildren().setAll((Collection<Node>)arrayList);
        this.requestLayout();
    }

    private void rebuildDragRects() {
        if (!this.isColumnResizingEnabled()) {
            return;
        }
        this.getChildren().removeAll((Collection<?>)this.dragRects);
        this.dragRects.clear();
        if (this.getColumns() == null) {
            return;
        }
        boolean bl = TableView.CONSTRAINED_RESIZE_POLICY.equals(this.getTableView().getColumnResizePolicy());
        for (int i = 0; !(i >= this.getColumns().size() || bl && i == this.getColumns().size() - 1); ++i) {
            TableColumn tableColumn = (TableColumn)this.getColumns().get(i);
            Rectangle rectangle = new Rectangle();
            rectangle.getProperties().put(TABLE_COLUMN_KEY, tableColumn);
            rectangle.getProperties().put(TABLE_COLUMN_HEADER_KEY, this);
            rectangle.setWidth(4.0);
            rectangle.setHeight(this.getHeight() - this.label.getHeight());
            rectangle.setFill(Color.TRANSPARENT);
            rectangle.visibleProperty().bind(tableColumn.visibleProperty());
            rectangle.setSmooth(false);
            rectangle.setOnMousePressed(rectMousePressed);
            rectangle.setOnMouseDragged(rectMouseDragged);
            rectangle.setOnMouseReleased(rectMouseReleased);
            rectangle.setOnMouseEntered(rectCursorChangeListener);
            rectangle.setOnMouseExited(rectCursorChangeListener);
            this.dragRects.add(rectangle);
        }
    }

    private boolean isColumnResizingEnabled() {
        return !PlatformUtil.isEmbedded();
    }

    private void columnResizingStarted(double d) {
        this.getTableHeaderRow().getColumnReorderLine().setLayoutX(d);
    }

    private void columnResizing(TableColumn tableColumn, MouseEvent mouseEvent) {
        double d = mouseEvent.getSceneX() - this.dragAnchorX;
        double d2 = d - this.lastX;
        boolean bl = this.getTableView().resizeColumn(tableColumn, d2);
        if (bl) {
            this.lastX = d;
        }
    }

    private void columnResizingComplete(TableColumn tableColumn, MouseEvent mouseEvent) {
        this.getTableHeaderRow().getColumnReorderLine().setTranslateX(0.0);
        this.getTableHeaderRow().getColumnReorderLine().setLayoutX(0.0);
        this.lastX = 0.0;
    }

    @Override
    protected void layoutChildren() {
        double d = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d2 = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        int n = (int)this.label.prefHeight(-1.0);
        if (this.label.isVisible()) {
            this.label.resize(d, n);
            this.label.relocate(this.getInsets().getLeft(), this.getInsets().getTop());
        }
        double d3 = this.getInsets().getLeft();
        int n2 = 0;
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            if (!tableColumnHeader.isVisible()) continue;
            double d4 = this.snapSize(tableColumnHeader.prefWidth(-1.0));
            tableColumnHeader.resize(d4, this.snapSize(d2 - (double)n));
            tableColumnHeader.relocate(d3, (double)n + this.getInsets().getTop());
            d3 += d4;
            if (this.dragRects == null || n2 >= this.dragRects.size()) continue;
            Rectangle rectangle = this.dragRects.get(n2++);
            rectangle.setHeight(this.getHeight() - this.label.getHeight());
            rectangle.relocate(d3 - 2.0, this.getInsets().getTop() + (double)n);
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        if (this.getColumns() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                if (!tableColumnHeader.isVisible()) continue;
                d2 += this.snapSize(tableColumnHeader.computePrefWidth(d));
            }
        }
        return d2;
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        if (this.getColumnHeaders() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                d2 = Math.max(d2, tableColumnHeader.prefHeight(-1.0));
            }
        }
        return d2 + this.label.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    private TableColumnHeader createColumnHeader(TableColumn tableColumn) {
        TableColumnHeader tableColumnHeader = tableColumn.getColumns().isEmpty() ? new TableColumnHeader(this.getTableView(), tableColumn) : new NestedTableColumnHeader(this.getTableView(), tableColumn);
        tableColumnHeader.setTableHeaderRow(this.getTableHeaderRow());
        tableColumnHeader.setParentHeader(this);
        return tableColumnHeader;
    }
}

