/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputControl;

public class TextField
extends TextInputControl {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 12;
    private IntegerProperty prefColumnCount = new IntegerPropertyBase(12){

        @Override
        public void set(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("value cannot be negative.");
            }
            super.set(n);
        }

        @Override
        public Object getBean() {
            return TextField.this;
        }

        @Override
        public String getName() {
            return "prefColumnCount";
        }
    };
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            TextField.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return TextField.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };
    private ObjectProperty<Pos> alignment;

    public TextField() {
        this("");
    }

    public TextField(String string) {
        super(new TextFieldContent());
        this.getStyleClass().add("text-field");
        this.setText(string);
    }

    public CharSequence getCharacters() {
        return ((TextFieldContent)this.getContent()).characters;
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int n) {
        this.prefColumnCount.setValue(n);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.CENTER_LEFT){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return TextField.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER_LEFT : (Pos)((Object)this.alignment.get());
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TextField.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TextField, Pos> ALIGNMENT = new StyleableProperty<TextField, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.CENTER_LEFT){

            @Override
            public boolean isSettable(TextField textField) {
                return textField.alignment == null || !textField.alignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(TextField textField) {
                return textField.alignmentProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private static final class TextFieldContent
    implements TextInputControl.Content {
        private ExpressionHelper<String> helper = null;
        private StringBuilder characters = new StringBuilder();

        private TextFieldContent() {
        }

        @Override
        public String get(int n, int n2) {
            return this.characters.substring(n, n2);
        }

        @Override
        public void insert(int n, String string, boolean bl) {
            if (!(string = TextInputControl.filterInput(string, true, true)).isEmpty()) {
                this.characters.insert(n, string);
                if (bl) {
                    ExpressionHelper.fireValueChangedEvent(this.helper);
                }
            }
        }

        @Override
        public void delete(int n, int n2, boolean bl) {
            if (n2 > n) {
                this.characters.delete(n, n2);
                if (bl) {
                    ExpressionHelper.fireValueChangedEvent(this.helper);
                }
            }
        }

        @Override
        public int length() {
            return this.characters.length();
        }

        @Override
        public String get() {
            return this.characters.toString();
        }

        @Override
        public void addListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public String getValue() {
            return this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }
    }
}

