/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;

public class SwipeEvent
extends GestureEvent {
    public static final EventType<SwipeEvent> ANY = new EventType<GestureEvent>(GestureEvent.ANY, "ANY_SWIPE");
    public static final EventType<SwipeEvent> SWIPE_LEFT = new EventType<SwipeEvent>(ANY, "SWIPE_LEFT");
    public static final EventType<SwipeEvent> SWIPE_RIGHT = new EventType<SwipeEvent>(ANY, "SWIPE_RIGHT");
    public static final EventType<SwipeEvent> SWIPE_UP = new EventType<SwipeEvent>(ANY, "SWIPE_UP");
    public static final EventType<SwipeEvent> SWIPE_DOWN = new EventType<SwipeEvent>(ANY, "SWIPE_DOWN");
    private int touchCount;

    private SwipeEvent(EventType<? extends SwipeEvent> eventType) {
        super((EventType<? extends GestureEvent>)eventType);
    }

    private SwipeEvent(Object object, EventTarget eventTarget, EventType<? extends SwipeEvent> eventType) {
        super(object, eventTarget, (EventType<? extends GestureEvent>)eventType);
    }

    private SwipeEvent(EventType<? extends SwipeEvent> eventType, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(eventType, d, d2, d3, d4, bl, bl2, bl3, bl4, bl5, false);
        this.touchCount = n;
    }

    public static SwipeEvent impl_swipeEvent(EventType<? extends SwipeEvent> eventType, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return new SwipeEvent(eventType, n, d, d2, d3, d4, bl, bl2, bl3, bl4, bl5);
    }

    public int getTouchCount() {
        return this.touchCount;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SwipeEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", touchCount = ").append(this.getTouchCount());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        stringBuilder.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }
}

