/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.BasicExceptionDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JEditorPaneBasedExceptionDialog
extends JDialog
implements HyperlinkListener {
    private JButton closeButton;
    private JButton closeAndCopyButton;
    private JButton homeButton;
    private JButton aboutButton;
    private JButton consoleButton;
    private JButton cacheButton;
    private JEditorPane htmlErrorAndHelpPanel;
    private JLabel exceptionLabel;
    private JLabel iconLabel;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JScrollPane htmlPaneScroller;
    private final String message;
    private final Throwable exception;
    private final Date shown = new Date();
    private final String anotherInfo;

    public JEditorPaneBasedExceptionDialog(Frame parent, boolean modal, Throwable ex, InformationElement information, String anotherInfo) {
        super(parent, modal);
        this.initComponents();
        this.htmlErrorAndHelpPanel.setContentType("text/html");
        this.htmlErrorAndHelpPanel.setEditable(false);
        this.anotherInfo = anotherInfo;
        List<String> l = JEditorPaneBasedExceptionDialog.infoElementToList(information);
        this.message = JEditorPaneBasedExceptionDialog.getText(ex, l, anotherInfo, this.shown);
        this.exception = ex;
        if (this.exception == null) {
            this.closeAndCopyButton.setVisible(false);
        }
        this.htmlErrorAndHelpPanel.setText(this.message);
        this.htmlErrorAndHelpPanel.setCaretPosition(0);
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/net/sourceforge/jnlp/resources/warning.png"));
            this.iconLabel.setIcon(icon);
        }
        catch (Exception lex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, lex);
        }
        this.htmlErrorAndHelpPanel.addHyperlinkListener(this);
        this.homeButton.setVisible(false);
        this.setDefaultCloseOperation(2);
    }

    static List<String> infoElementToList(InformationElement information) {
        List<String> l = null;
        if (information != null) {
            l = information.getHeader();
            InfoItem ii = information.getLongestDescriptionForSplash();
            if (ii != null) {
                l.add(ii.toNiceString());
            }
        }
        return l;
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.closeButton = new JButton();
        this.closeAndCopyButton = new JButton();
        this.mainPanel = new JPanel();
        this.exceptionLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.htmlPaneScroller = new JScrollPane();
        this.htmlErrorAndHelpPanel = new JEditorPane();
        this.homeButton = new JButton();
        this.aboutButton = new JButton();
        this.consoleButton = BasicExceptionDialog.getShowButton(this);
        this.cacheButton = BasicExceptionDialog.getClearCacheButton(this);
        this.setDefaultCloseOperation(2);
        this.closeButton.setText(Translator.R("SPLASHClose"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JEditorPaneBasedExceptionDialog.this.closeWindowButtonActionPerformed(evt);
            }
        });
        this.closeAndCopyButton.setText(Translator.R("SPLASHclosewAndCopyException"));
        this.closeAndCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JEditorPaneBasedExceptionDialog.this.copyAndCloseButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.closeButton).addContainerGap().addComponent(this.aboutButton).addContainerGap().addComponent(this.cacheButton).addContainerGap().addComponent(this.consoleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 314, Short.MAX_VALUE).addComponent(this.closeAndCopyButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.aboutButton).addComponent(this.cacheButton).addComponent(this.consoleButton).addComponent(this.closeAndCopyButton)).addContainerGap()));
        this.exceptionLabel.setFont(new Font("Dialog", 1, 18));
        this.exceptionLabel.setHorizontalAlignment(0);
        this.exceptionLabel.setText(Translator.R("SPLASHexOccured"));
        this.bottomPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.bottomPanel.setLayout(new BorderLayout());
        this.htmlPaneScroller.setViewportView(this.htmlErrorAndHelpPanel);
        this.bottomPanel.add((Component)this.htmlPaneScroller, "Center");
        this.homeButton.setText(Translator.R("SPLASHHome"));
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JEditorPaneBasedExceptionDialog.this.homeButtonActionPerformed(evt);
            }
        });
        this.aboutButton.setText(Translator.R("AboutDialogueTabAbout"));
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AboutDialog.display(true, "icedtea-web-plugin");
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    JOptionPane.showConfirmDialog(JEditorPaneBasedExceptionDialog.this, ex);
                }
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.iconLabel, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exceptionLabel, -1, 503, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homeButton, -2, 101, -2).addContainerGap()).addComponent(this.bottomPanel, GroupLayout.Alignment.TRAILING, -1, 723, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -2, 70, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exceptionLabel, -2, 70, -2).addComponent(this.homeButton, -2, 64, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bottomPanel, -1, 158, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.topPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.topPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void copyAndCloseButtonActionPerformed(ActionEvent evt) {
        if (this.exception != null) {
            try {
                StringSelection data = new StringSelection(this.anotherInfo + "\n" + this.shown.toString() + "\n" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(this.exception) + JEditorPaneBasedExceptionDialog.addPlainChain());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                JOptionPane.showMessageDialog(this, Translator.R("SPLASHcantCopyEx"));
            }
        } else {
            JOptionPane.showMessageDialog(this, Translator.R("SPLASHnoExRecorded"));
        }
        this.close();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        this.htmlErrorAndHelpPanel.setText(this.message);
        this.homeButton.setVisible(false);
    }

    private void closeWindowButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RuntimeException ex = new RuntimeException("dsgsfdg");
                JEditorPaneBasedExceptionDialog dialog = new JEditorPaneBasedExceptionDialog(new JFrame(), true, ex, null, "uaaa: aaa\nwqdeweq:sdsds");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    static String getText(Throwable ex, List<String> l, String anotherInfo, Date shown) {
        StringBuilder s = new StringBuilder("<html><body>");
        String info = "<p>" + Translator.R("SPLASHmainL1", JEditorPaneBasedExceptionDialog.createLink()) + " </p> \n" + "<p>" + Translator.R("SPLASHmainL2", JEditorPaneBasedExceptionDialog.createLink()) + " </p> \n";
        String t = "<p>" + Translator.R("SPLASHmainL3") + "</p> \n" + info + JEditorPaneBasedExceptionDialog.formatListInfoList(l) + JEditorPaneBasedExceptionDialog.formatInfo(anotherInfo);
        String[] options = new String[]{Translator.R("SPLASHClose"), Translator.R("SPLASHcloseAndCopyShorter")};
        t = ex != null ? "<p>" + Translator.R("SPLASHmainL4") + " </p>\n" + info + JEditorPaneBasedExceptionDialog.formatListInfoList(l) + JEditorPaneBasedExceptionDialog.formatInfo(anotherInfo) + "<br/>" + DateFormat.getInstance().format(shown) + "<br/>" + "<p>" + Translator.R("SPLASHexWas") + " <br/>\n" + "<pre>" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(ex) + "</pre>" + JEditorPaneBasedExceptionDialog.addChain() : t + JEditorPaneBasedExceptionDialog.formatListInfoList(l);
        s.append(t);
        s.append("</body></html>");
        return s.toString();
    }

    public static String getExceptionStackTraceAsString(Throwable exception) {
        if (exception == null) {
            return "";
        }
        return OutputController.exceptionToString(exception);
    }

    public static String[] getExceptionStackTraceAsStrings(Throwable exception) {
        if (exception == null) {
            return new String[0];
        }
        return OutputController.exceptionToString(exception).split("\n");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlErrorAndHelpPanel.setPage(event.getURL());
                this.homeButton.setVisible(true);
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, Translator.R("SPLASHcfl") + " " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    static String formatListInfoList(List<String> l) {
        if (l == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("<h3>").append(Translator.R("SPLASHvendorsInfo")).append(":</h3>");
        sb.append("<pre>");
        for (int i = 0; i < l.size(); ++i) {
            String string = l.get(i);
            sb.append(string).append("\n");
        }
        sb.append("</pre>");
        sb.append("</p>");
        return sb.toString();
    }

    static String formatInfo(String l) {
        if (l == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("<h3>").append(Translator.R("SPLASHanotherInfo")).append(": </h3>");
        sb.append("<pre>");
        sb.append(l);
        sb.append("</pre>");
        sb.append("</p>");
        return sb.toString();
    }

    Throwable getException() {
        return this.exception;
    }

    String getMessage() {
        return this.message;
    }

    private static String createLink() {
        return "<a href=\"http://icedtea.classpath.org/wiki/IcedTea-Web#Filing_bugs\">http://icedtea.classpath.org/wiki/IcedTea-Web</a>";
    }

    private static String addChain() {
        if (LaunchException.getLaunchExceptionChain().isEmpty()) {
            return "";
        }
        return Translator.R("SPLASHchainWas") + " <br/>\n" + "<pre>" + JEditorPaneBasedExceptionDialog.getChainAsString(true) + "</pre>";
    }

    private static String addPlainChain() {
        if (LaunchException.getLaunchExceptionChain().isEmpty()) {
            return "";
        }
        return "\n Chain: \n" + JEditorPaneBasedExceptionDialog.getChainAsString(false);
    }

    private static String getChainAsString(boolean formatTime) {
        return JEditorPaneBasedExceptionDialog.getChainAsString(LaunchException.getLaunchExceptionChain(), formatTime);
    }

    private static String getChainAsString(List<LaunchException.LaunchExceptionWithStamp> launchExceptionChain, boolean formatTime) {
        String s = "";
        if (launchExceptionChain != null) {
            for (int i = 0; i < launchExceptionChain.size(); ++i) {
                LaunchException.LaunchExceptionWithStamp launchException = launchExceptionChain.get(i);
                s = s + (i + 1) + ") at " + JEditorPaneBasedExceptionDialog.formatTime(launchException.getStamp(), formatTime) + "\n" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(launchException.getEx());
            }
        }
        return s;
    }

    private static String formatTime(Date dateTime, boolean formatTime) {
        if (dateTime == null) {
            return "unknown time";
        }
        if (formatTime) {
            return DateFormat.getInstance().format(dateTime);
        }
        return dateTime.toString();
    }
}

