/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class PropMap
implements SortedMap<Object, Object> {
    private final TreeMap<Object, Object> theMap = new TreeMap();
    private final List<PropertyChangeListener> listenerList = new ArrayList<PropertyChangeListener>(1);
    private static Map<Object, Object> defaultProps;

    void addListener(PropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    void removeListener(PropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    void addListeners(ArrayList<PropertyChangeListener> listeners) {
        this.listenerList.addAll(listeners);
    }

    void removeListeners(ArrayList<PropertyChangeListener> listeners) {
        this.listenerList.removeAll(listeners);
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldValue = this.theMap.put(key, value);
        if (value != oldValue && !this.listenerList.isEmpty()) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, (String)key, oldValue, value);
            for (PropertyChangeListener listener : this.listenerList) {
                listener.propertyChange(event);
            }
        }
        return oldValue;
    }

    PropMap() {
        this.theMap.putAll(defaultProps);
    }

    SortedMap<Object, Object> prefixMap(String prefix) {
        int len = prefix.length();
        if (len == 0) {
            return this;
        }
        char nextch = (char)(prefix.charAt(len - 1) + '\u0001');
        String limit = prefix.substring(0, len - 1) + nextch;
        return this.subMap(prefix, limit);
    }

    String getProperty(String s) {
        return (String)this.get(s);
    }

    String getProperty(String s, String defaultVal) {
        String val = this.getProperty(s);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    String setProperty(String s, String val) {
        return (String)this.put(s, val);
    }

    List getProperties(String prefix) {
        Collection<Object> values = this.prefixMap(prefix).values();
        ArrayList<Object> res = new ArrayList<Object>(values.size());
        res.addAll(values);
        while (res.remove(null)) {
        }
        return res;
    }

    private boolean toBoolean(String val) {
        return Boolean.valueOf(val);
    }

    boolean getBoolean(String s) {
        return this.toBoolean(this.getProperty(s));
    }

    boolean setBoolean(String s, boolean val) {
        return this.toBoolean(this.setProperty(s, String.valueOf(val)));
    }

    int toInteger(String val) {
        if (val == null) {
            return 0;
        }
        if ("true".equals(val)) {
            return 1;
        }
        if ("false".equals(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    int getInteger(String s) {
        return this.toInteger(this.getProperty(s));
    }

    int setInteger(String s, int val) {
        return this.toInteger(this.setProperty(s, String.valueOf(val)));
    }

    long toLong(String val) {
        try {
            return val == null ? 0L : Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String s) {
        return this.toLong(this.getProperty(s));
    }

    long setLong(String s, long val) {
        return this.toLong(this.setProperty(s, String.valueOf(val)));
    }

    int getTime(String s) {
        String sval = this.getProperty(s, "0");
        if ("now".equals(sval)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long lval = this.toLong(sval);
        long recentSecondCount = 1000000000L;
        if (lval < 10000000000L && !"0".equals(sval)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + sval);
        }
        return (int)((lval + 500L) / 1000L);
    }

    void list(PrintStream out) {
        PrintWriter outw = new PrintWriter(out);
        this.list(outw);
        outw.flush();
    }

    void list(PrintWriter out) {
        out.println("#PACK200[");
        Set<Map.Entry<Object, Object>> defaults = defaultProps.entrySet();
        for (Map.Entry<Object, Object> e : this.theMap.entrySet()) {
            if (defaults.contains(e)) continue;
            out.println("  " + e.getKey() + " = " + e.getValue());
        }
        out.println("#]");
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.theMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.theMap.get(key);
    }

    @Override
    public Object remove(Object key) {
        return this.theMap.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.theMap.putAll(m);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.theMap.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.theMap.entrySet();
    }

    @Override
    public Comparator<Object> comparator() {
        return this.theMap.comparator();
    }

    @Override
    public SortedMap<Object, Object> subMap(Object fromKey, Object toKey) {
        return this.theMap.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<Object, Object> headMap(Object toKey) {
        return this.theMap.headMap(toKey);
    }

    @Override
    public SortedMap<Object, Object> tailMap(Object fromKey) {
        return this.theMap.tailMap(fromKey);
    }

    @Override
    public Object firstKey() {
        return this.theMap.firstKey();
    }

    @Override
    public Object lastKey() {
        return this.theMap.lastKey();
    }

    static {
        Properties props = new Properties();
        props.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        props.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        props.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        props.put("pack.segment.limit", "-1");
        props.put("pack.keep.file.order", "true");
        props.put("pack.modification.time", "keep");
        props.put("pack.deflate.hint", "keep");
        props.put("pack.unknown.attribute", "pass");
        props.put("pack.effort", "5");
        String propFile = "intrinsic.properties";
        try {
            Throwable throwable = null;
            try (InputStream propStr = PackerImpl.class.getResourceAsStream(propFile);){
                if (propStr == null) {
                    throw new RuntimeException(propFile + " cannot be loaded");
                }
                props.load(propStr);
            }
            catch (Throwable x2) {
                Throwable throwable2 = x2;
                throw x2;
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!key.startsWith("attribute.")) continue;
            entry.setValue(Attribute.normalizeLayoutString(val));
        }
        defaultProps = new HashMap<Object, Object>(props);
    }
}

