# From 5.4 to 6.0
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/5.4-to-6.0.md) for the most up to date instructions.*

## Warning

GitLab 6.0 is affected by critical security vulnerabilities CVE-2013-4490 and CVE-2013-4489.

**You need to follow this guide first, before updating past 6.0, as it contains critical migration steps that are only present
in the `6-0-stable` branch**

## Deprecations

### Global projects

The root (global) namespace for projects is deprecated.

So you need to move all your global projects under groups or users manually before update or they will be automatically moved to the project owner namespace during the update. When a project is moved all its members will receive an email with instructions how to update their git remote URL. Please make sure you disable sending email when you do a test of the upgrade.

### Teams

We introduce group membership in 6.0 as a replacement for teams.

The old combination of groups and teams was confusing for a lot of people.

And when the members of a team where changed this wasn't reflected in the project permissions.

In GitLab 6.0 you will be able to add members to a group with a permission level for each member.

These group members will have access to the projects in that group.

Any changes to group members will immediately be reflected in the project permissions.

You can even have multiple owners for a group, greatly simplifying administration.

## 0. Backup

It's useful to make a backup just in case things go south (with MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version):

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch
sudo -u git -H git checkout 6-0-stable
```

## 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.7.9
```

## 4. Install additional packages

```bash
# For reStructuredText markup language support install required package:
sudo apt-get install python-docutils
```

## 5. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u git -H vim Gemfile

# MySQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test postgres --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test mysql --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test mysql --deployment

# Both MySQL and PostgreSQL
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_groups RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_global_projects RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_keys RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_inline_notes RAILS_ENV=production
sudo -u git -H bundle exec rake gitlab:satellites:create RAILS_ENV=production

# Clear redis cache
sudo -u git -H bundle exec rake cache:clear RAILS_ENV=production

# Clear and precompile assets
sudo -u git -H bundle exec rake assets:clean RAILS_ENV=production
sudo -u git -H bundle exec rake assets:precompile RAILS_ENV=production
```

## 6. Update config files

Note: We switched from Puma in GitLab 5.4 to unicorn in GitLab 6.0.

- Make `/home/git/gitlab/config/gitlab.yml` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/master/config/gitlab.yml.example but with your settings.
- Make `/home/git/gitlab/config/unicorn.rb` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/master/config/unicorn.rb.example but with your settings.

## 7. Update Init script

```bash
sudo rm /etc/init.d/gitlab
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab
```

## 8. Start application

    sudo service gitlab start
    sudo service nginx restart

## 9. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Troubleshooting

The migrations in this update are very sensitive to incomplete or inconsistent data. If you have a long-running GitLab installation and some of the previous upgrades did not work out 100% correct this may bite you now. The following commands can be run in the rails console to look for 'bad' data.

All project owners should have an owner:

```
Project.all.select { |project| project.owner.blank? }
```

Every user should have a namespace:

```
User.all.select { |u| u.namespace.blank? }
```

Projects in the global namespace should not conflict with projects in the owner namespace:

```
Project.where(namespace_id: nil).select { |p| Project.where(path: p.path, namespace_id: p.owner.try(:namespace).try(:id)).present? }
```
