/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.Set;

public class EnumerationType
extends BaseType {
    protected boolean ordered = false;
    protected boolean circular = false;
    protected Enumeration enumeration = null;

    public EnumerationType() {
    }

    public EnumerationType(Enumeration enumeration, boolean ordered, boolean circular) {
        this.ordered = ordered;
        this.circular = circular;
        this.enumeration = enumeration;
    }

    public void setOrdered(boolean ordered) throws PropertyVetoException {
        boolean oldValue = this.ordered;
        boolean newValue = ordered;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("ordered", oldValue, newValue);
        if (!newValue && this.isCircular()) {
            this.fireVetoableChange("circular", true, false);
            this.circular = false;
            this.firePropertyChange("circular", true, false);
        }
        this.ordered = newValue;
        this.firePropertyChange("ordered", oldValue, newValue);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) throws PropertyVetoException {
        boolean oldValue = this.circular;
        boolean newValue = circular;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("circular", oldValue, newValue);
        if (newValue && !this.isOrdered()) {
            this.fireVetoableChange("ordered", false, true);
            this.ordered = true;
            this.firePropertyChange("ordered", false, true);
        }
        this.circular = newValue;
        this.firePropertyChange("circular", oldValue, newValue);
    }

    public Enumeration getEnumeration() {
        return this.enumeration;
    }

    public Enumeration getConsolidatedEnumeration() {
        if (this.extending == null) {
            return new Enumeration(this.enumeration);
        }
        Enumeration ret = ((EnumerationType)this.extending.resolveAliases()).getConsolidatedEnumeration();
        if (this.enumeration.isFinal()) {
            ret.setFinal(true);
        }
        Iterator elei = this.enumeration.getElements();
        while (elei.hasNext()) {
            Enumeration.Element ele = (Enumeration.Element)elei.next();
            EnumerationType.mergeTree(ret, ele);
        }
        return ret;
    }

    static void mergeTree(Enumeration tree, Enumeration.Element newele) {
        Iterator desti = tree.getElements();
        while (desti.hasNext()) {
            Enumeration.Element dest = (Enumeration.Element)desti.next();
            if (!dest.getName().equals(newele.getName())) continue;
            if (newele.getSubEnumeration() != null) {
                if (dest.getSubEnumeration() != null) {
                    if (newele.getSubEnumeration().isFinal()) {
                        dest.getSubEnumeration().setFinal(true);
                    }
                    Iterator elei = newele.getSubEnumeration().getElements();
                    while (elei.hasNext()) {
                        Enumeration.Element ele = (Enumeration.Element)elei.next();
                        EnumerationType.mergeTree(dest.getSubEnumeration(), ele);
                    }
                } else {
                    dest.setSubEnumeration(new Enumeration(newele.getSubEnumeration()));
                }
            }
            return;
        }
        tree.addElement(new Enumeration.Element(newele));
    }

    public void setEnumeration(Enumeration enumeration) throws PropertyVetoException {
        Enumeration oldValue = this.enumeration;
        Enumeration newValue = enumeration;
        this.fireVetoableChange("enumeration", oldValue, newValue);
        this.enumeration = newValue;
        this.firePropertyChange("enumeration", oldValue, newValue);
    }

    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof EnumerationType)) {
            throw new IllegalArgumentException(rsrc.getString("err_enumerationType_ExtOther"));
        }
        EnumerationType general = (EnumerationType)wantToExtend;
        Enumeration thisEnum = this.enumeration;
        Enumeration generalEnum = general.getConsolidatedEnumeration();
        Iterator elei = thisEnum.getElements();
        while (elei.hasNext()) {
            Enumeration.Element ele = (Enumeration.Element)elei.next();
            EnumerationType.checkTree(generalEnum, ele);
        }
    }

    public Set getDirectExtensions() {
        return this.extendedBy;
    }

    static void checkTree(Enumeration tree, Enumeration.Element newele) {
        Iterator desti = tree.getElements();
        while (desti.hasNext()) {
            Enumeration.Element dest = (Enumeration.Element)desti.next();
            if (!dest.getName().equals(newele.getName())) continue;
            if (newele.getSubEnumeration() != null && dest.getSubEnumeration() != null) {
                Iterator elei = newele.getSubEnumeration().getElements();
                while (elei.hasNext()) {
                    Enumeration.Element ele = (Enumeration.Element)elei.next();
                    EnumerationType.checkTree(dest.getSubEnumeration(), ele);
                }
            }
            return;
        }
        if (tree.isFinal()) {
            throw new IllegalArgumentException(EnumerationType.formatMessage("err_enumerationType_ExtFinal", newele.getName()));
        }
    }

    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        EnumerationType other = (EnumerationType)with;
        boolean fine = true;
        if (this.isCircular() != other.isCircular()) {
            EhiLogger.logError(EnumerationType.formatMessage("err_diff_enumType_mismatchInCircularity", this.toString(), with.toString()));
            fine = false;
        }
        if (this.isOrdered() != other.isOrdered()) {
            EhiLogger.logError(EnumerationType.formatMessage("err_diff_enumType_mismatchInOrderedness", this.toString(), with.toString()));
            fine = false;
        }
        if (!this.areEnumerationsStructurallyEquivalent(this.getEnumeration(), other.getEnumeration())) {
            fine = false;
        }
        return fine;
    }

    private boolean areEnumerationsStructurallyEquivalent(Enumeration a, Enumeration b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Iterator iter_a = a.getElements();
        Iterator iter_b = b.getElements();
        while (iter_a.hasNext() && iter_b.hasNext()) {
            Enumeration.Element elt_b;
            Enumeration.Element elt_a = (Enumeration.Element)iter_a.next();
            if (elt_a == null != ((elt_b = (Enumeration.Element)iter_b.next()) == null)) {
                return false;
            }
            if (elt_a == null || elt_b == null || this.areEnumerationsStructurallyEquivalent(elt_a.getSubEnumeration(), elt_b.getSubEnumeration())) continue;
            return false;
        }
        return iter_a.hasNext() == iter_b.hasNext();
    }
}

