/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.HashSet;
import java.util.Set;
import org.jruby.util.cli.Options;

public class PerformanceWarnings {
    public static final String KWARGS_NOT_OPTIMIZED_YET = "Ruby keyword arguments are not yet optimized";
    private static final boolean ENABLED = (Boolean)Options.TRUFFLE_PERF_WARNING.load();
    private static final Set<String> DISPLAYED_WARNINGS = new HashSet<String>();

    public static void warn(String message) {
        if (ENABLED) {
            PerformanceWarnings.doWarn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private static void doWarn(String message) {
        Set<String> set = DISPLAYED_WARNINGS;
        synchronized (set) {
            if (DISPLAYED_WARNINGS.add(message)) {
                System.err.println("[perf warning] " + message);
            }
        }
    }
}

