/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder);
        }
    };

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(@NotNull String exprText, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        if (exprText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprText", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createExpressionFromText"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createExpressionFromText"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createExpressionFromText"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        try {
            PsiExpression expr = parserFacade.createExpressionFromText(exprText, null);
            return ClsParsingUtil.psiToClsExpression(expr, parent2);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static PsiAnnotationMemberValue createMemberValueFromText(@NotNull String text, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createMemberValueFromText"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createMemberValueFromText"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createMemberValueFromText"));
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(parent2);
        DummyHolder holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level), null);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            return null;
        }
        return ClsParsingUtil.getMemberValue(element, parent2);
    }

    public static PsiAnnotationMemberValue getMemberValue(@NotNull PsiElement element, @NotNull ClsElementImpl parent2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
        }
        if (element instanceof PsiExpression) {
            return ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent2);
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent2, clsInitializers);
            for (int i = 0; i < initializers.length; ++i) {
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
            }
            return arrayValue;
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            return new ClsAnnotationValueImpl(parent2){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                @Override
                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)((Object)this.getParent());
                }
            };
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        return null;
    }

    static PsiExpression psiToClsExpression(@NotNull PsiExpression expr, @NotNull ClsElementImpl parent2) {
        String exprText;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
        }
        if (expr instanceof PsiLiteralExpression) {
            boolean forDecompiling = ((ClsFileImpl)parent2.getContainingFile()).isForDecompiling();
            PsiType type2 = forDecompiling ? PsiType.NULL : expr.getType();
            Object value = forDecompiling ? null : ((PsiLiteralExpression)expr).getValue();
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), type2, value);
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiJavaToken sign = ((PsiPrefixExpression)expr).getOperationSign();
            PsiExpression operand = ((PsiPrefixExpression)expr).getOperand();
            if (operand == null) {
                LOG.error("Invalid prefix expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsPrefixExpressionImpl(parent2, sign, operand);
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith(exprText = expr.getText(), ".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            return new ClsClassObjectAccessExpressionImpl(parent2, classText);
        }
        if (expr instanceof PsiReferenceExpression) {
            return new ClsReferenceExpressionImpl(parent2, (PsiReferenceExpression)expr);
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiJavaToken sign = ((PsiBinaryExpression)expr).getOperationSign();
            PsiExpression left = ((PsiBinaryExpression)expr).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expr).getROperand();
            if (right == null) {
                LOG.error("Invalid binary expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsBinaryExpressionImpl(parent2, sign, left, right);
        }
        if (((ClsFileImpl)parent2.getContainingFile()).isForDecompiling()) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), PsiType.NULL, null);
        }
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
        Object value = evaluator.computeConstantExpression(expr);
        if (value != null) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), expr.getType(), value);
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/psi/impl/compiled/ClsParsingUtil", "isJavaIdentifier"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/psi/impl/compiled/ClsParsingUtil", "isJavaIdentifier"));
        }
        return StringUtil.isJavaIdentifier(identifier) && !JavaLexer.isKeyword(identifier, level);
    }

    @Nullable
    public static LanguageLevel getLanguageLevelByVersion(int major) {
        switch (major) {
            case 45: 
            case 46: 
            case 47: 
            case 196653: {
                return LanguageLevel.JDK_1_3;
            }
            case 48: {
                return LanguageLevel.JDK_1_4;
            }
            case 49: {
                return LanguageLevel.JDK_1_5;
            }
            case 50: {
                return LanguageLevel.JDK_1_6;
            }
            case 51: {
                return LanguageLevel.JDK_1_7;
            }
            case 52: {
                return LanguageLevel.JDK_1_8;
            }
            case 53: {
                return LanguageLevel.JDK_1_9;
            }
        }
        return null;
    }
}

