/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools.callgraph;

import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.tools.callgraph.CallSite;
import org.jruby.truffle.tools.callgraph.CallSiteVersion;
import org.jruby.truffle.tools.callgraph.Calls;
import org.jruby.truffle.tools.callgraph.CallsForeign;
import org.jruby.truffle.tools.callgraph.CallsMegamorphic;
import org.jruby.truffle.tools.callgraph.CallsMethod;
import org.jruby.truffle.tools.callgraph.Method;

public class MethodVersion {
    private final Method method;
    private final RubyRootNode rootNode;
    private final Map<CallSite, CallSiteVersion> callSiteVersions = new HashMap<CallSite, CallSiteVersion>();
    private final Set<String> evalCode = new HashSet<String>();

    public MethodVersion(Method method, RubyRootNode rootNode) {
        this.method = method;
        this.rootNode = rootNode;
        method.getVersions().add(this);
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<CallSite, CallSiteVersion> getCallSiteVersions() {
        return this.callSiteVersions;
    }

    public void resolve() {
        this.rootNode.accept(node -> {
            this.resolve(node);
            return true;
        });
    }

    private void resolve(Node node) {
        if (node instanceof DirectCallNode || node instanceof IndirectCallNode) {
            Calls calls;
            CallSiteVersion callSiteVersion = this.getCallSiteVersion(node);
            if (node instanceof DirectCallNode) {
                DirectCallNode directNode = (DirectCallNode)node;
                RootNode rootNode = directNode.getCurrentRootNode();
                if (rootNode instanceof RubyRootNode) {
                    MethodVersion methodVersion = this.method.getCallGraph().rootNodeToMethodVersion((RubyRootNode)rootNode);
                    calls = new CallsMethod(methodVersion);
                } else {
                    calls = CallsForeign.INSTANCE;
                }
            } else {
                calls = CallsMegamorphic.INSTANCE;
            }
            callSiteVersion.getCalls().add(calls);
        } else if (node.getClass().getName().indexOf("EvalNoBindingCachedNode") != -1) {
            try {
                Field f = node.getClass().getDeclaredField("cachedSource");
                f.setAccessible(true);
                this.evalCode.add(f.get(node).toString());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private CallSiteVersion getCallSiteVersion(Node node) {
        CallSite callSite = this.method.getCallSite(node);
        CallSiteVersion callSiteVersion = this.callSiteVersions.get(callSite);
        if (callSiteVersion == null) {
            callSiteVersion = new CallSiteVersion(callSite, this);
            this.callSiteVersions.put(callSite, callSiteVersion);
        }
        return callSiteVersion;
    }

    public RubyRootNode getRootNode() {
        return this.rootNode;
    }

    public Set<String> getEvalCode() {
        return this.evalCode;
    }
}

