/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class StringLiteral
extends AstNode {
    private String value;
    private char quoteChar;

    public StringLiteral() {
        this.type = 41;
    }

    public StringLiteral(int n) {
        super(n);
        this.type = 41;
    }

    public StringLiteral(int n, int n2) {
        super(n, n2);
        this.type = 41;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(boolean bl) {
        if (!bl) {
            return this.value;
        }
        return this.quoteChar + this.value + this.quoteChar;
    }

    public void setValue(String string) {
        this.assertNotNull(string);
        this.value = string;
    }

    public char getQuoteCharacter() {
        return this.quoteChar;
    }

    public void setQuoteCharacter(char c) {
        this.quoteChar = c;
    }

    @Override
    public String toSource(int n) {
        return this.makeIndent(n) + this.quoteChar + ScriptRuntime.escapeString(this.value, this.quoteChar) + this.quoteChar;
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

