/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.Crypt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JndiLoginModule
implements LoginModule {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.AuthResources");
    public final String USER_PROVIDER = "user.provider.url";
    public final String GROUP_PROVIDER = "group.provider.url";
    private boolean debug = false;
    private boolean strongDebug = false;
    private String userProvider;
    private String groupProvider;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    DirContext ctx;
    private UnixPrincipal userPrincipal;
    private UnixNumericUserPrincipal UIDPrincipal;
    private UnixNumericGroupPrincipal GIDPrincipal;
    private LinkedList<UnixNumericGroupPrincipal> supplementaryGroups = new LinkedList();
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map<String, ?> options;
    private static final String CRYPT = "{crypt}";
    private static final String USER_PWD = "userPassword";
    private static final String USER_UID = "uidNumber";
    private static final String USER_GID = "gidNumber";
    private static final String GROUP_ID = "gidNumber";
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.strongDebug = "true".equalsIgnoreCase((String)options.get("strongDebug"));
        this.userProvider = (String)options.get("user.provider.url");
        this.groupProvider = (String)options.get("group.provider.url");
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)options.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)options.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)options.get("clearPass"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (this.userProvider == null) {
            throw new LoginException("Error: Unable to locate JNDI user provider");
        }
        if (this.groupProvider == null) {
            throw new LoginException("Error: Unable to locate JNDI group provider");
        }
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule] user provider: " + this.userProvider);
            System.out.println("\t\t[JndiLoginModule] group provider: " + this.groupProvider);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] tryFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl32
                System.out.println("\t\t[JndiLoginModule] tryFirstPass failed with:" + le.toString());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] useFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] useFirstPass failed");
                }
                throw le;
            }
        }
lbl32:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (this.debug) {
                System.out.println("\t\t[JndiLoginModule] regular authentication succeeded");
            }
            return true;
        }
        catch (LoginException le) {
            this.cleanState();
            if (this.debug) {
                System.out.println("\t\t[JndiLoginModule] regular authentication failed");
            }
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (this.subject.getPrincipals().contains(this.supplementaryGroups.get(i))) continue;
            this.subject.getPrincipals().add(this.supplementaryGroups.get(i));
        }
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: added UnixPrincipal,");
            System.out.println("\t\t\t\tUnixNumericUserPrincipal,");
            System.out.println("\t\t\t\tUnixNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: aborted authentication failed");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            this.subject.getPrincipals().remove(this.supplementaryGroups.get(i));
        }
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: logged out Subject");
        }
        return true;
    }

    private void attemptAuthentication(boolean getPasswdFromSharedState) throws LoginException {
        block15: {
            String encryptedPassword = null;
            this.getUsernamePassword(getPasswdFromSharedState);
            try {
                InitialContext iCtx = new InitialContext();
                this.ctx = (DirContext)iCtx.lookup(this.userProvider);
                SearchControls controls = new SearchControls();
                NamingEnumeration<SearchResult> ne = this.ctx.search("", "(uid=" + this.username + ")", controls);
                if (ne.hasMore()) {
                    SearchResult result = ne.next();
                    Attributes attributes = result.getAttributes();
                    Attribute pwd = attributes.get(USER_PWD);
                    String encryptedPwd = new String((byte[])pwd.get(), "UTF8");
                    encryptedPassword = encryptedPwd.substring(CRYPT.length());
                    if (this.verifyPassword(encryptedPassword, new String(this.password))) {
                        if (this.debug) {
                            System.out.println("\t\t[JndiLoginModule] attemptAuthentication() succeeded");
                        }
                    } else {
                        if (this.debug) {
                            System.out.println("\t\t[JndiLoginModule] attemptAuthentication() failed");
                        }
                        throw new FailedLoginException("Login incorrect");
                    }
                    if (this.storePass && !this.sharedState.containsKey(NAME) && !this.sharedState.containsKey(PWD)) {
                        this.sharedState.put(NAME, this.username);
                        this.sharedState.put(PWD, this.password);
                    }
                    this.userPrincipal = new UnixPrincipal(this.username);
                    Attribute uid = attributes.get(USER_UID);
                    String uidNumber = (String)uid.get();
                    this.UIDPrincipal = new UnixNumericUserPrincipal(uidNumber);
                    if (this.debug && uidNumber != null) {
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has UID: " + uidNumber);
                    }
                    Attribute gid = attributes.get("gidNumber");
                    String gidNumber = (String)gid.get();
                    this.GIDPrincipal = new UnixNumericGroupPrincipal(gidNumber, true);
                    if (this.debug && gidNumber != null) {
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has GID: " + gidNumber);
                    }
                    this.ctx = (DirContext)iCtx.lookup(this.groupProvider);
                    ne = this.ctx.search("", (Attributes)new BasicAttributes("memberUid", this.username));
                    while (ne.hasMore()) {
                        result = ne.next();
                        attributes = result.getAttributes();
                        gid = attributes.get("gidNumber");
                        String suppGid = (String)gid.get();
                        if (gidNumber.equals(suppGid)) continue;
                        UnixNumericGroupPrincipal suppPrincipal = new UnixNumericGroupPrincipal(suppGid, false);
                        this.supplementaryGroups.add(suppPrincipal);
                        if (!this.debug || suppGid == null) continue;
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has Supplementary Group: " + suppGid);
                    }
                    break block15;
                }
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]: User not found");
                }
                throw new FailedLoginException("User not found");
            }
            catch (NamingException ne) {
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]:  User not found");
                    ne.printStackTrace();
                }
                throw new FailedLoginException("User not found");
            }
            catch (UnsupportedEncodingException uee) {
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]:  password incorrectly encoded");
                    uee.printStackTrace();
                }
                throw new LoginException("Login failure due to incorrect password encoding in the password database");
            }
        }
    }

    private void getUsernamePassword(boolean getPasswdFromSharedState) throws LoginException {
        if (getPasswdFromSharedState) {
            this.username = (String)this.sharedState.get(NAME);
            this.password = (char[])this.sharedState.get(PWD);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        String protocol = this.userProvider.substring(0, this.userProvider.indexOf(":"));
        Callback[] callbacks = new Callback[]{new NameCallback(protocol + " " + rb.getString("username.")), new PasswordCallback(protocol + " " + rb.getString("password."), false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.strongDebug) {
            System.out.println("\t\t[JndiLoginModule] user entered username: " + this.username);
            System.out.print("\t\t[JndiLoginModule] user entered password: ");
            for (int i = 0; i < this.password.length; ++i) {
                System.out.print(this.password[i]);
            }
            System.out.println();
        }
    }

    private boolean verifyPassword(String encryptedPassword, String password) {
        if (encryptedPassword == null) {
            return false;
        }
        Crypt c = new Crypt();
        try {
            byte[] oldCrypt = encryptedPassword.getBytes("UTF8");
            byte[] newCrypt = c.crypt(password.getBytes("UTF8"), oldCrypt);
            if (newCrypt.length != oldCrypt.length) {
                return false;
            }
            for (int i = 0; i < newCrypt.length; ++i) {
                if (oldCrypt[i] == newCrypt[i]) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        return true;
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.ctx = null;
        if (this.clearPass) {
            this.sharedState.remove(NAME);
            this.sharedState.remove(PWD);
        }
    }
}

