/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.AbstractLayoutController;
import org.jfree.report.flow.layoutprocessor.BufferedReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;

public abstract class BufferingLayoutController
extends AbstractLayoutController {
    private BufferedReportTarget reportTarget = new BufferedReportTarget();
    private LayoutController delegate;
    private boolean finished;

    protected BufferingLayoutController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutController advance(ReportTarget reportTarget) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        this.reportTarget.setTarget(reportTarget);
        if (this.delegate != null) {
            try {
                BufferingLayoutController bufferingLayoutController = (BufferingLayoutController)this.clone();
                bufferingLayoutController.delegate = this.delegate.advance(this.reportTarget);
                BufferingLayoutController bufferingLayoutController2 = bufferingLayoutController;
                return bufferingLayoutController2;
            }
            finally {
                this.reportTarget.setTarget(null);
            }
        }
        this.reportTarget.close(reportTarget);
        if (this.getParent() == null) {
            BufferingLayoutController bufferingLayoutController = (BufferingLayoutController)this.clone();
            bufferingLayoutController.finished = true;
            return bufferingLayoutController;
        }
        return this.joinWithParent();
    }

    protected LayoutController joinWithParent() throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        LayoutController layoutController = this.getParent();
        if (layoutController == null) {
            throw new IllegalStateException("There is no parent to join with. This should not happen in a sane environment!");
        }
        return layoutController.join(this.getFlowController());
    }

    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(object, flowController, layoutController);
        this.delegate = this.getInitialDelegate();
    }

    protected abstract LayoutController getInitialDelegate();

    public boolean isAdvanceable() {
        if (this.delegate == null) {
            return !this.finished;
        }
        return this.delegate.isAdvanceable();
    }

    public LayoutController join(FlowController flowController) throws ReportProcessingException, DataSourceException {
        BufferingLayoutController bufferingLayoutController = (BufferingLayoutController)this.clone();
        bufferingLayoutController.delegate = null;
        return bufferingLayoutController;
    }

    public Object clone() {
        BufferingLayoutController bufferingLayoutController = (BufferingLayoutController)super.clone();
        bufferingLayoutController.reportTarget = (BufferedReportTarget)this.reportTarget.clone();
        return bufferingLayoutController;
    }
}

