/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public final class UrlToFileMapper {
    public static File mapUrlToFile(URL url) {
        if (url == null) {
            return null;
        }
        try {
            String encodedUrl = UrlToFileMapper.encode(url.toString());
            URI uri = new URI(encodedUrl);
            try {
                return new File(uri);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String encode(String url) {
        StringBuffer buf = new StringBuffer(url.length());
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '?' && c <= '[' || c >= '$' && c <= ';' || c == '!' || c == '=' || c == ']' || c == '_' || c == '~') {
                buf.append(c);
                continue;
            }
            if (c == ' ') {
                buf.append("%20");
                continue;
            }
            try {
                String enc = URLEncoder.encode(Character.toString(c), "UTF-8");
                buf.append(enc);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return buf.toString();
    }

    private UrlToFileMapper() {
    }
}

