/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizerSpi;
import com.sun.org.apache.xml.internal.security.c14n.helper.AttrCompare;
import com.sun.org.apache.xml.internal.security.c14n.implementations.NameSpaceSymbTable;
import com.sun.org.apache.xml.internal.security.c14n.implementations.UtfHelpper;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    private static final byte[] _END_PI = new byte[]{63, 62};
    private static final byte[] _BEGIN_PI = new byte[]{60, 63};
    private static final byte[] _END_COMM = new byte[]{45, 45, 62};
    private static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    private static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    private static final byte[] _END_TAG = new byte[]{60, 47};
    private static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    private static final byte[] _EQUALS_STR = new byte[]{61, 34};
    static final AttrCompare COMPARE = new AttrCompare();
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    List nodeFilter;
    boolean _includeComments;
    Set _xpathNodeSet = null;
    Node _excludeNode = null;
    OutputStream _writer = new UnsyncByteArrayOutputStream();
    private Attr nullNode;

    public CanonicalizerBase(boolean includeComments) {
        this._includeComments = includeComments;
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, (Node)null);
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet) throws CanonicalizationException {
        this._xpathNodeSet = xpathNodeSet;
        return this.engineCanonicalizeXPathNodeSetInternal(XMLUtils.getOwnerDocument(this._xpathNodeSet));
    }

    public byte[] engineCanonicalize(XMLSignatureInput input) throws CanonicalizationException {
        try {
            if (input.isExcludeComments()) {
                this._includeComments = false;
            }
            if (input.isOctetStream()) {
                return this.engineCanonicalize(input.getBytes());
            }
            if (input.isElement()) {
                byte[] bytes = this.engineCanonicalizeSubTree(input.getSubNode(), input.getExcludeNode());
                return bytes;
            }
            if (input.isNodeSet()) {
                this.nodeFilter = input.getNodeFilters();
                this.circumventBugIfNeeded(input);
                byte[] bytes = input.getSubNode() != null ? this.engineCanonicalizeXPathNodeSetInternal(input.getSubNode()) : this.engineCanonicalizeXPathNodeSet(input.getNodeSet());
                return bytes;
            }
            return null;
        }
        catch (CanonicalizationException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    @Override
    public void setWriter(OutputStream _writer) {
        this._writer = _writer;
    }

    byte[] engineCanonicalizeSubTree(Node rootNode, Node excludeNode) throws CanonicalizationException {
        this._excludeNode = excludeNode;
        try {
            NameSpaceSymbTable ns = new NameSpaceSymbTable();
            int nodeLevel = -1;
            if (rootNode != null && rootNode.getNodeType() == 1) {
                this.getParentNameSpaces((Element)rootNode, ns);
                nodeLevel = 0;
            }
            this.canonicalizeSubTree(rootNode, ns, rootNode, nodeLevel);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] result = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            if (this._writer instanceof UnsyncByteArrayOutputStream) {
                byte[] result = ((UnsyncByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((UnsyncByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    final void canonicalizeSubTree(Node currentNode, NameSpaceSymbTable ns, Node endnode, int documentLevel) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(currentNode) == -1) {
            return;
        }
        Node sibling = null;
        Node parentNode = null;
        OutputStream writer = this._writer;
        Node excludeNode = this._excludeNode;
        boolean includeComments = this._includeComments;
        HashMap cache = new HashMap();
        while (true) {
            switch (currentNode.getNodeType()) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    ns.outputNodePush();
                    sibling = currentNode.getFirstChild();
                    break;
                }
                case 8: {
                    if (!includeComments) break;
                    CanonicalizerBase.outputCommentToWriter((Comment)currentNode, writer, documentLevel);
                    break;
                }
                case 7: {
                    CanonicalizerBase.outputPItoWriter((ProcessingInstruction)currentNode, writer, documentLevel);
                    break;
                }
                case 3: 
                case 4: {
                    CanonicalizerBase.outputTextToWriter(currentNode.getNodeValue(), writer);
                    break;
                }
                case 1: {
                    documentLevel = 0;
                    if (currentNode == excludeNode) break;
                    Element currentElement = (Element)currentNode;
                    ns.outputNodePush();
                    writer.write(60);
                    String name = currentElement.getTagName();
                    UtfHelpper.writeByte(name, writer, cache);
                    Iterator attrs = this.handleAttributesSubtree(currentElement, ns);
                    if (attrs != null) {
                        while (attrs.hasNext()) {
                            Attr attr = (Attr)attrs.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), writer, cache);
                        }
                    }
                    writer.write(62);
                    sibling = currentNode.getFirstChild();
                    if (sibling == null) {
                        writer.write((byte[])_END_TAG.clone());
                        UtfHelpper.writeStringToUtf8(name, writer);
                        writer.write(62);
                        ns.outputNodePop();
                        if (parentNode == null) break;
                        sibling = currentNode.getNextSibling();
                        break;
                    }
                    parentNode = currentElement;
                }
            }
            while (sibling == null && parentNode != null) {
                writer.write((byte[])_END_TAG.clone());
                UtfHelpper.writeByte(((Element)parentNode).getTagName(), writer, cache);
                writer.write(62);
                ns.outputNodePop();
                if (parentNode == endnode) {
                    return;
                }
                sibling = parentNode.getNextSibling();
                if ((parentNode = parentNode.getParentNode()) == null || parentNode.getNodeType() == 1) continue;
                documentLevel = 1;
                parentNode = null;
            }
            if (sibling == null) {
                return;
            }
            currentNode = sibling;
            sibling = currentNode.getNextSibling();
        }
    }

    private byte[] engineCanonicalizeXPathNodeSetInternal(Node doc) throws CanonicalizationException {
        try {
            this.canonicalizeXPathNodeSet(doc, doc);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] sol = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return sol;
            }
            if (this._writer instanceof UnsyncByteArrayOutputStream) {
                byte[] result = ((UnsyncByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((UnsyncByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    final void canonicalizeXPathNodeSet(Node currentNode, Node endnode) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(currentNode) == -1) {
            return;
        }
        boolean currentNodeIsVisible = false;
        NameSpaceSymbTable ns = new NameSpaceSymbTable();
        if (currentNode != null && currentNode.getNodeType() == 1) {
            this.getParentNameSpaces((Element)currentNode, ns);
        }
        Node sibling = null;
        Node parentNode = null;
        OutputStream writer = this._writer;
        int documentLevel = -1;
        HashMap cache = new HashMap();
        while (true) {
            switch (currentNode.getNodeType()) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    ns.outputNodePush();
                    sibling = currentNode.getFirstChild();
                    break;
                }
                case 8: {
                    if (!this._includeComments || this.isVisibleDO(currentNode, ns.getLevel()) != 1) break;
                    CanonicalizerBase.outputCommentToWriter((Comment)currentNode, writer, documentLevel);
                    break;
                }
                case 7: {
                    if (!this.isVisible(currentNode)) break;
                    CanonicalizerBase.outputPItoWriter((ProcessingInstruction)currentNode, writer, documentLevel);
                    break;
                }
                case 3: 
                case 4: {
                    if (!this.isVisible(currentNode)) break;
                    CanonicalizerBase.outputTextToWriter(currentNode.getNodeValue(), writer);
                    for (Node nextSibling = currentNode.getNextSibling(); nextSibling != null && (nextSibling.getNodeType() == 3 || nextSibling.getNodeType() == 4); nextSibling = nextSibling.getNextSibling()) {
                        CanonicalizerBase.outputTextToWriter(nextSibling.getNodeValue(), writer);
                        currentNode = nextSibling;
                        sibling = currentNode.getNextSibling();
                    }
                    break;
                }
                case 1: {
                    documentLevel = 0;
                    Element currentElement = (Element)currentNode;
                    String name = null;
                    int i = this.isVisibleDO(currentNode, ns.getLevel());
                    if (i == -1) {
                        sibling = currentNode.getNextSibling();
                        break;
                    }
                    boolean bl = currentNodeIsVisible = i == 1;
                    if (currentNodeIsVisible) {
                        ns.outputNodePush();
                        writer.write(60);
                        name = currentElement.getTagName();
                        UtfHelpper.writeByte(name, writer, cache);
                    } else {
                        ns.push();
                    }
                    Iterator attrs = this.handleAttributes(currentElement, ns);
                    if (attrs != null) {
                        while (attrs.hasNext()) {
                            Attr attr = (Attr)attrs.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), writer, cache);
                        }
                    }
                    if (currentNodeIsVisible) {
                        writer.write(62);
                    }
                    if ((sibling = currentNode.getFirstChild()) == null) {
                        if (currentNodeIsVisible) {
                            writer.write((byte[])_END_TAG.clone());
                            UtfHelpper.writeByte(name, writer, cache);
                            writer.write(62);
                            ns.outputNodePop();
                        } else {
                            ns.pop();
                        }
                        if (parentNode == null) break;
                        sibling = currentNode.getNextSibling();
                        break;
                    }
                    parentNode = currentElement;
                }
            }
            while (sibling == null && parentNode != null) {
                if (this.isVisible(parentNode)) {
                    writer.write((byte[])_END_TAG.clone());
                    UtfHelpper.writeByte(((Element)parentNode).getTagName(), writer, cache);
                    writer.write(62);
                    ns.outputNodePop();
                } else {
                    ns.pop();
                }
                if (parentNode == endnode) {
                    return;
                }
                sibling = parentNode.getNextSibling();
                if ((parentNode = parentNode.getParentNode()) == null || parentNode.getNodeType() == 1) continue;
                parentNode = null;
                documentLevel = 1;
            }
            if (sibling == null) {
                return;
            }
            currentNode = sibling;
            sibling = currentNode.getNextSibling();
        }
    }

    int isVisibleDO(Node currentNode, int level) {
        if (this.nodeFilter != null) {
            Iterator it = this.nodeFilter.iterator();
            while (it.hasNext()) {
                int i = ((NodeFilter)it.next()).isNodeIncludeDO(currentNode, level);
                if (i == 1) continue;
                return i;
            }
        }
        if (this._xpathNodeSet != null && !this._xpathNodeSet.contains(currentNode)) {
            return 0;
        }
        return 1;
    }

    int isVisibleInt(Node currentNode) {
        if (this.nodeFilter != null) {
            Iterator it = this.nodeFilter.iterator();
            while (it.hasNext()) {
                int i = ((NodeFilter)it.next()).isNodeInclude(currentNode);
                if (i == 1) continue;
                return i;
            }
        }
        if (this._xpathNodeSet != null && !this._xpathNodeSet.contains(currentNode)) {
            return 0;
        }
        return 1;
    }

    boolean isVisible(Node currentNode) {
        if (this.nodeFilter != null) {
            Iterator it = this.nodeFilter.iterator();
            while (it.hasNext()) {
                if (((NodeFilter)it.next()).isNodeInclude(currentNode) == 1) continue;
                return false;
            }
        }
        return this._xpathNodeSet == null || this._xpathNodeSet.contains(currentNode);
    }

    void handleParent(Element e, NameSpaceSymbTable ns) {
        if (!e.hasAttributes()) {
            return;
        }
        NamedNodeMap attrs = e.getAttributes();
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            Attr N = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/" != N.getNamespaceURI()) continue;
            String NName = N.getLocalName();
            String NValue = N.getNodeValue();
            if (XML.equals(NName) && "http://www.w3.org/XML/1998/namespace".equals(NValue)) continue;
            ns.addMapping(NName, NValue, N);
        }
    }

    final void getParentNameSpaces(Element el, NameSpaceSymbTable ns) {
        ArrayList<Element> parents = new ArrayList<Element>(10);
        Node n1 = el.getParentNode();
        if (n1 == null || n1.getNodeType() != 1) {
            return;
        }
        for (Node parent = n1; parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            parents.add((Element)parent);
        }
        ListIterator it = parents.listIterator(parents.size());
        while (it.hasPrevious()) {
            Element ele = (Element)it.previous();
            this.handleParent(ele, ns);
        }
        Attr nsprefix = ns.getMappingWithoutRendered(XMLNS);
        if (nsprefix != null && "".equals(nsprefix.getValue())) {
            ns.addMappingAndRender(XMLNS, "", this.getNullNode(nsprefix.getOwnerDocument()));
        }
    }

    abstract Iterator handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Iterator handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract void circumventBugIfNeeded(XMLSignatureInput var1) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException;

    static final void outputAttrToWriter(String name, String value, OutputStream writer, Map cache) throws IOException {
        writer.write(32);
        UtfHelpper.writeByte(name, writer, cache);
        writer.write((byte[])_EQUALS_STR.clone());
        int length = value.length();
        int i = 0;
        block8: while (i < length) {
            byte[] toWrite;
            char c = value.charAt(i++);
            switch (c) {
                case '&': {
                    toWrite = (byte[])_AMP_.clone();
                    break;
                }
                case '<': {
                    toWrite = (byte[])_LT_.clone();
                    break;
                }
                case '\"': {
                    toWrite = (byte[])_QUOT_.clone();
                    break;
                }
                case '\t': {
                    toWrite = (byte[])__X9_.clone();
                    break;
                }
                case '\n': {
                    toWrite = (byte[])__XA_.clone();
                    break;
                }
                case '\r': {
                    toWrite = (byte[])__XD_.clone();
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        writer.write(c);
                        continue block8;
                    }
                    UtfHelpper.writeCharToUtf8(c, writer);
                    continue block8;
                }
            }
            writer.write(toWrite);
        }
        writer.write(34);
    }

    static final void outputPItoWriter(ProcessingInstruction currentPI, OutputStream writer, int position) throws IOException {
        if (position == 1) {
            writer.write(10);
        }
        writer.write((byte[])_BEGIN_PI.clone());
        String target = currentPI.getTarget();
        int length = target.length();
        for (int i = 0; i < length; ++i) {
            char c = target.charAt(i);
            if (c == '\r') {
                writer.write((byte[])__XD_.clone());
                continue;
            }
            if (c < '\u0080') {
                writer.write(c);
                continue;
            }
            UtfHelpper.writeCharToUtf8(c, writer);
        }
        String data = currentPI.getData();
        length = data.length();
        if (length > 0) {
            writer.write(32);
            for (int i = 0; i < length; ++i) {
                char c = data.charAt(i);
                if (c == '\r') {
                    writer.write((byte[])__XD_.clone());
                    continue;
                }
                UtfHelpper.writeCharToUtf8(c, writer);
            }
        }
        writer.write((byte[])_END_PI.clone());
        if (position == -1) {
            writer.write(10);
        }
    }

    static final void outputCommentToWriter(Comment currentComment, OutputStream writer, int position) throws IOException {
        if (position == 1) {
            writer.write(10);
        }
        writer.write((byte[])_BEGIN_COMM.clone());
        String data = currentComment.getData();
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(i);
            if (c == '\r') {
                writer.write((byte[])__XD_.clone());
                continue;
            }
            if (c < '\u0080') {
                writer.write(c);
                continue;
            }
            UtfHelpper.writeCharToUtf8(c, writer);
        }
        writer.write((byte[])_END_COMM.clone());
        if (position == -1) {
            writer.write(10);
        }
    }

    static final void outputTextToWriter(String text, OutputStream writer) throws IOException {
        int length = text.length();
        block6: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = (byte[])_AMP_.clone();
                    break;
                }
                case '<': {
                    toWrite = (byte[])_LT_.clone();
                    break;
                }
                case '>': {
                    toWrite = (byte[])_GT_.clone();
                    break;
                }
                case '\r': {
                    toWrite = (byte[])__XD_.clone();
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        writer.write(c);
                        continue block6;
                    }
                    UtfHelpper.writeCharToUtf8(c, writer);
                    continue block6;
                }
            }
            writer.write(toWrite);
        }
    }

    protected Attr getNullNode(Document ownerDocument) {
        if (this.nullNode == null) {
            try {
                this.nullNode = ownerDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS);
                this.nullNode.setValue("");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create nullNode: " + e);
            }
        }
        return this.nullNode;
    }
}

