/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptableObject {
    static final long serialVersionUID = -7471457301304454454L;
    private static final Object CALL_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeFunction function;
    Object[] originalArgs;
    transient NativeCall parentActivationCall;

    static void init(Scriptable scriptable, boolean bl) {
        NativeCall nativeCall = new NativeCall();
        nativeCall.exportAsJSClass(1, scriptable, bl);
    }

    NativeCall() {
    }

    NativeCall(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray) {
        String string;
        int n;
        this.function = nativeFunction;
        this.setParentScope(scriptable);
        this.originalArgs = objectArray == null ? ScriptRuntime.emptyArgs : objectArray;
        int n2 = nativeFunction.getParamAndVarCount();
        int n3 = nativeFunction.getParamCount();
        if (n2 != 0) {
            for (n = 0; n != n3; ++n) {
                string = nativeFunction.getParamOrVarName(n);
                Object object = n < objectArray.length ? objectArray[n] : Undefined.instance;
                this.defineProperty(string, object, 4);
            }
        }
        if (!super.has("arguments", (Scriptable)this)) {
            this.defineProperty("arguments", new Arguments(this), 4);
        }
        if (n2 != 0) {
            for (n = n3; n != n2; ++n) {
                string = nativeFunction.getParamOrVarName(n);
                if (super.has(string, (Scriptable)this)) continue;
                this.defineProperty(string, Undefined.instance, 4);
            }
        }
    }

    public String getClassName() {
        return "Call";
    }

    protected int findPrototypeId(String string) {
        return string.equals("constructor") ? 1 : 0;
    }

    protected void initPrototypeId(int n) {
        if (n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = 1;
        String string = "constructor";
        this.initPrototypeMethod(CALL_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CALL_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            if (scriptable2 != null) {
                throw Context.reportRuntimeError1("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(context, "Call");
            NativeCall nativeCall = new NativeCall();
            nativeCall.setPrototype(NativeCall.getObjectPrototype(scriptable));
            return nativeCall;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }
}

