/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.AbstractSingleArchiveResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class WarResource
extends AbstractSingleArchiveResource {
    private static final Log log = LogFactory.getLog(WarResource.class);

    public WarResource(AbstractArchiveResourceSet archiveResourceSet, String webAppPath, String baseUrl, JarEntry jarEntry) {
        super(archiveResourceSet, webAppPath, "war:" + baseUrl, jarEntry, baseUrl);
    }

    @Override
    public URL getURL() {
        String url = this.getBaseUrl() + "*/" + this.getResource().getName();
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{url}), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

