/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMember
implements PrimitiveId {
    private final String role;
    private final OsmPrimitive member;

    public String getRole() {
        return this.role;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public boolean hasRole(String ... stringArray) {
        return Arrays.asList(stringArray).contains(this.role);
    }

    public boolean isRelation() {
        return this.member instanceof Relation;
    }

    public boolean isWay() {
        return this.member instanceof Way;
    }

    public OsmPrimitiveType getDisplayType() {
        return this.member.getDisplayType();
    }

    public boolean isNode() {
        return this.member instanceof Node;
    }

    public Relation getRelation() {
        return (Relation)this.member;
    }

    public Way getWay() {
        return (Way)this.member;
    }

    public Node getNode() {
        return (Node)this.member;
    }

    public OsmPrimitive getMember() {
        return this.member;
    }

    public RelationMember(String string, OsmPrimitive osmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "member");
        if (string == null) {
            string = "";
        }
        this.role = string;
        this.member = osmPrimitive;
    }

    public RelationMember(RelationMember relationMember) {
        this(relationMember.role, relationMember.member);
    }

    public String toString() {
        return '\"' + this.role + "\"=" + this.member;
    }

    public boolean refersTo(OsmPrimitive osmPrimitive) {
        return this.member == osmPrimitive;
    }

    public int hashCode() {
        return Objects.hash(this.role, this.member);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelationMember relationMember = (RelationMember)object;
        return Objects.equals(this.role, relationMember.role) && Objects.equals(this.member, relationMember.member);
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.member.getType();
    }

    @Override
    public long getUniqueId() {
        return this.member.getUniqueId();
    }

    @Override
    public boolean isNew() {
        return this.member.isNew();
    }
}

