/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class FileWatcher {
    private WatchService watcher;
    private Thread thread;
    private final Map<Path, StyleSource> styleMap = new HashMap<Path, StyleSource>();
    private final Map<Path, SourceEntry> ruleMap = new HashMap<Path, SourceEntry>();

    public FileWatcher() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.thread = new Thread(this::processEvents, "File Watcher");
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public final void start() {
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
    }

    public void registerStyleSource(StyleSource styleSource) throws IOException {
        this.register(styleSource, this.styleMap);
    }

    public void registerValidatorRule(SourceEntry sourceEntry) throws IOException {
        this.register(sourceEntry, this.ruleMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends SourceEntry> void register(T t, Map<Path, T> map) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(t, "obj");
        if (this.watcher == null) {
            throw new IllegalStateException("File watcher is not available");
        }
        File file = new File(t.url);
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IllegalArgumentException("Resource " + t + " does not have a parent directory");
        }
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            file2.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            map.put(file.toPath(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        WatchKey watchKey;
        if (Main.isDebugEnabled()) {
            Main.debug("File watcher thread started");
        }
        do {
            try {
                watchKey = this.watcher.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                WatchEvent<?> watchEvent2;
                Path path;
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (StandardWatchEventKinds.OVERFLOW.equals(kind) || (path = (Path)(watchEvent2 = watchEvent).context()) == null) continue;
                Path path2 = ((Path)watchKey.watchable()).resolve(path);
                FileWatcher fileWatcher = this;
                synchronized (fileWatcher) {
                    StyleSource styleSource = this.styleMap.get(path2);
                    SourceEntry sourceEntry = this.ruleMap.get(path2);
                    if (styleSource != null) {
                        Main.info("Map style " + styleSource.getDisplayString() + " has been modified. Reloading style...");
                        Main.worker.submit(new MapPaintStyles.MapPaintStyleLoader(Collections.singleton(styleSource)));
                    } else if (sourceEntry != null) {
                        Main.info("Validator rule " + sourceEntry.getDisplayString() + " has been modified. Reloading rule...");
                        MapCSSTagChecker mapCSSTagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
                        if (mapCSSTagChecker != null) {
                            try {
                                mapCSSTagChecker.addMapCSS(sourceEntry.url);
                            }
                            catch (IOException | ParseException exception) {
                                Main.warn(exception);
                            }
                        }
                    } else if (Main.isDebugEnabled()) {
                        Main.debug("Received " + kind.name() + " event for unregistered file: " + path2);
                    }
                }
            }
        } while (watchKey.reset());
    }
}

