/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocumentRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.VersionType;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocumentRequest<DeleteRequest> {
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private static DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(DeleteRequest.class));

    public DeleteRequest() {
    }

    public DeleteRequest(String index) {
        this.index = index;
    }

    public DeleteRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForWrites(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        if (this.versionType == VersionType.FORCE) {
            deprecationLogger.deprecated("version type FORCE is deprecated and will be removed in the next major version", new Object[0]);
        }
        return validationException;
    }

    @Override
    public String type() {
        return this.type;
    }

    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    public DeleteRequest parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        out.writeOptionalString(this.parent());
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.type + "][" + this.id + "]}";
    }
}

